/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.util;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNumberUtil {
    private static Logger logger = LoggerFactory.getLogger(SerialNumberUtil.class);
    public static final int MAX = 99999999;
    public static final int COURSE_MAX = 99999999;
    private static final int[] bitMap = new int[]{11, 8, 4, 0, 16, 14, 22, 7, 3, 5, 13, 18, 24, 25, 23, 10, 1, 12, 6, 21, 17, 2, 15, 9, 19, 20};
    private static final int SUFFIX = 9;

    public static int generateNumber(int id, int max) {
        SerialNumberUtil.assertId(id, max);
        int encodedId = SerialNumberUtil.encode(id, max);
        int number = SerialNumberUtil.allocateStart(max) + encodedId;
        int serialNumber = number * 10 + 9;
        logger.info("generate serialNumber-id:{},encodedId;{},number:{},serailNumber:{}", new Object[]{id, encodedId, number, serialNumber});
        return serialNumber;
    }

    public static long generateNumber(int id, int max, int suffix) {
        SerialNumberUtil.assertId(id, max);
        int encodedId = SerialNumberUtil.encode(id, max);
        int number = SerialNumberUtil.allocateStart(max) + encodedId;
        Long serialNum = Long.parseLong(number + "") * 100L + (long)suffix;
        return serialNum;
    }

    private static int allocateMax(int max) {
        return (int)Math.pow(2.0, SerialNumberUtil.power(max)) - 1;
    }

    private static int power(int max) {
        return (int)(Math.log(max) / Math.log(2.0));
    }

    private static int allocateStart(int max) {
        return max - (int)Math.pow(2.0, SerialNumberUtil.power(max)) + 1;
    }

    private static void assertId(int id, int max) {
        int allocateMax = SerialNumberUtil.allocateMax(max);
        if (id > allocateMax) {
            throw new RuntimeException("generateNumber by id:" + id + " out of range [1," + allocateMax + "] ...");
        }
    }

    private static int encode(int id, int max) {
        int encodedId = 0;
        for (int i = 0; i < SerialNumberUtil.power(max); ++i) {
            int tmp = id >> i & 1;
            encodedId |= tmp << bitMap[i];
        }
        return encodedId;
    }

    private static int[] mapBit(int power) {
        int[] bit = new int[power + 1];
        for (int i = 0; i <= power / 2; ++i) {
            if (i % 2 == 0) {
                bit[i] = power - i;
                bit[power - i] = i;
                continue;
            }
            bit[i] = i;
            bit[power - i] = power - i;
        }
        return bit;
    }

    public static void main(String[] args) {
        System.out.println(SerialNumberUtil.power(99999999));
        System.out.println(Arrays.toString(bitMap));
        for (int i = 0; i < 1000000; i += 1000) {
            System.out.println(SerialNumberUtil.generateNumber(i, 99999999, 4));
        }
    }
}

