
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.enums;


/**
 * @author leiruiqi
 * @version 1.0
 * @title CourseTypeEnum
 * @desc TODO
 * @date 2016年9月13日
 */

public enum CourseTypeEnum {
    COURSE_TYPE_CLASS(1, "班课"),
    COURSE_TYPE_1v1(2, "1对1"),
    COURSE_TYPE_NEW_CLASS(3, "班课"),//按课时课消的新班课

    COURSE_TYPE_CLASS_LIVE(11, "直播课"),
    COURSE_TYPE_CLASS_VIDEO(12, "视频课"),

    IS_COURSE_TRUE(1),// 是课程
    IS_COURSE_FALSE(0),// 不是课程

    IS_CLASS_TRUE(1),// 是班级
    IS_CLASS_FALSE(0),// 不是班级

    // 当是班课时,既是课程又是班级.
    // 当是1v1时,课程班级二选一, 班级pid = 课程id.
    ;

    public static CourseTypeEnum getByCode(int code) {
        for (CourseTypeEnum p : values()) {
            if (p.getCode() == code) {
                return p;
            }
        }
        return null;
    }

    private Integer code;

    private String msg;

    public Integer getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    CourseTypeEnum(int code) {
        this.code = code;
    }

    CourseTypeEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static boolean isOneToOne(Integer type) {
        return COURSE_TYPE_1v1.code.equals(type);
    }

    public static boolean isClassCourse(Integer type) {
        if (COURSE_TYPE_NEW_CLASS.getCode().intValue() == type.intValue()) {
            return true;
        }
        if (COURSE_TYPE_CLASS.getCode().intValue() == type.intValue()) {
            return true;
        }
        return false;
    }
}

    