/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.user.dao;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

public interface UserDao extends CommonDao<User> {

    User getByNumber(Long number, String...queryProps);

    List<User> getByNumbers(Collection<Long> number, String...queryProps);

    User getByMobile(String mobile, String...queryProps);

    List<User> getByMobiles(Collection<String> mobiles, String...queryProps);

    Map<Long, User> getMapByIds(Collection<Long> ids, String...queryProps);

    /**
     * 查看手机号码是否已经被注册
     */
    boolean exist(String mobile);

    List<User> queryByUserIds(Collection<Long> userIds, String...queryProps);

    Map<Long, String> getUserMobile(Collection<Long> ids);

    List<User> getUsersByMobile(String mobile, String...queryPros);
    
}
