package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.TeacherCourseDao;
import com.baijia.tianxiao.dal.course.po.TeacherCourse;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.List;

/**
 * Created by wengshengli on 16/1/13.
 */
@Repository
public class TeacherCourseDaoImpl extends JdbcTemplateDaoSupport<TeacherCourse> implements TeacherCourseDao {

    public TeacherCourseDaoImpl() {
        super(TeacherCourse.class);
    }


    @Override
    public TeacherCourse getByCouseNumber(Long courseNumber) {
        SingleSqlBuilder<TeacherCourse> builder = createSqlBuilder();
        builder.eq("number", courseNumber);
        return uniqueResult(builder);
    }


    @Override
    public List<TeacherCourse> getTeacherCourseList(Collection<Long> courseNumbers) {
        SingleSqlBuilder<TeacherCourse> builder = createSqlBuilder();
        builder.in("number", courseNumbers);
        return queryList(builder);
    }
}
