package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.OrgCoursePhotoDao;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
/*
 * 
 * @title OrgCoursePhotoDaoImpl
 * @desc TODO 
 * @author shizuwei
 * @date 2016年4月14日
 * @version 1.0
 */
@Repository
public class OrgCoursePhotoDaoImpl extends JdbcTemplateDaoSupport<OrgCoursePhoto> implements OrgCoursePhotoDao {

    @Override
    public OrgCoursePhoto getLastAddPhoto(Long courseId) {
        SingleSqlBuilder<OrgCoursePhoto> builder = createSqlBuilder();
        builder.desc("createTime");
        builder.eq("orgCourseId", courseId);
        List<OrgCoursePhoto> list = this.queryList(builder);
        return CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
    }
    
    @Override
    public boolean isPhotoExist(Long courseId, Long storageId) {
        SingleSqlBuilder<OrgCoursePhoto> builder = createSqlBuilder("id");
        builder.desc("createTime");
        builder.eq("orgCourseId", courseId);
        builder.eq("storageId", storageId);
        List<OrgCoursePhoto> list = this.queryList(builder);
        return CollectionUtils.isNotEmpty(list) ? true : false;
    }

    @Override
    public List<OrgCoursePhoto> queryByCourseIds(List<Long> courseIds) {
        SingleSqlBuilder<OrgCoursePhoto> builder = createSqlBuilder();
        builder.asc("createTime");
        if(CollectionUtils.isEmpty(courseIds)){
            return new ArrayList<OrgCoursePhoto>();
        }
        builder.in("orgCourseId", courseIds);
        
        List<OrgCoursePhoto> list = this.queryList(builder);
        return list;
        
    }

}
