/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.ClassCourseScheduleDao;
import com.baijia.tianxiao.dal.course.po.ClassCourseSchedule;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ClassCourseScheduleImpl
extends JdbcTemplateDaoSupport<ClassCourseSchedule>
implements ClassCourseScheduleDao {
    @Override
    public Map<Long, Integer> getCourseTimeMap(Collection<Long> courseNumbers, Date time, Long orgNumber) {
        List<ClassCourseSchedule> list = this.getCoursseSchedule(courseNumbers, time, orgNumber, "courseNumber");
        HashMap result = Maps.newHashMap();
        for (ClassCourseSchedule classCourseSchedule : list) {
            if (!result.containsKey(classCourseSchedule.getCourseNumber())) {
                result.put(classCourseSchedule.getCourseNumber(), 0);
            }
            result.put(classCourseSchedule.getCourseNumber(), (Integer)result.get(classCourseSchedule.getCourseNumber()) + 1);
        }
        return result;
    }

    @Override
    public List<ClassCourseSchedule> getCoursseSchedule(Collection<Long> courseNumbers, final Date time, final Long orgNumber, final String ... queryProps) {
        if (CollectionUtils.isEmpty(courseNumbers)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(courseNumbers, (BatchQueryCallback)new BatchQueryCallback<Long, List<ClassCourseSchedule>>(){

            public List<ClassCourseSchedule> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = ClassCourseScheduleImpl.this.createSqlBuilder(queryProps);
                if (time != null) {
                    builder.le("endTime", (Serializable)time);
                }
                builder.eq("orgNumber", (Serializable)orgNumber);
                builder.in("courseNumber", querySet);
                return ClassCourseScheduleImpl.this.queryList(builder);
            }
        });
    }
}

