/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public enum OrderStatus {
    UNCOMMENT(-1, "\u5f85\u8bc4\u4ef7"),
    ING(0, "\u5f85\u652f\u4ed8"),
    SUCC(1, "\u4ed8\u6b3e\u6210\u529f"),
    FAIL(2, "\u652f\u4ed8\u5931\u8d25"),
    UNPAID_CANCEL(3, "\u5df2\u53d6\u6d88(\u672a\u652f\u4ed8)"),
    EXPIRED(4, "7\u5929\u672a\u652f\u4ed8,\u81ea\u52a8\u5173\u95ed"),
    PAID_CANCEL(5, "\u5df2\u53d6\u6d88(\u5df2\u652f\u4ed8)"),
    UNDER_WAY(10, "\u8fdb\u884c\u4e2d"),
    APPEALING(40, "\u7533\u8bc9\u4e2d"),
    SOLVED(31, "\u5df2\u5904\u7406"),
    NO_CLASS_CANCEL(32, "\u5df2\u53d6\u6d88(\u672a\u4e0a\u8bfe)"),
    FIRST_CLASS_CANCEL(33, "\u5df2\u53d6\u6d88(\u9996\u6b21\u8bfe\u53d6\u6d88)"),
    MANY_CLASS_CANCEL(34, "\u5df2\u53d6\u6d88(\u4e0a\u8bfe\u540e)"),
    FINISHED(20, "\u5df2\u5b8c\u6210"),
    ALL_FINISHED_THREE_LATER(30, "\u6240\u6709\u8bfe\u65f6\u5b8c\u62103\u5929\u540e");

    private static List<OrderStatus> searchableList;
    private static Map<Integer, OrderStatus> map;
    private int code;
    private String note;

    static {
        searchableList = Lists.newArrayList();
        map = Maps.newHashMap();
        searchableList.add(ING);
        searchableList.add(EXPIRED);
        searchableList.add(UNPAID_CANCEL);
        searchableList.add(UNDER_WAY);
        searchableList.add(APPEALING);
        searchableList.add(SOLVED);
        searchableList.add(NO_CLASS_CANCEL);
        searchableList.add(FIRST_CLASS_CANCEL);
        searchableList.add(MANY_CLASS_CANCEL);
        searchableList.add(FINISHED);
        searchableList.add(ALL_FINISHED_THREE_LATER);
        searchableList.add(UNCOMMENT);
        map.put(0, ING);
        map.put(4, EXPIRED);
        map.put(3, UNPAID_CANCEL);
        map.put(10, UNDER_WAY);
        map.put(40, APPEALING);
        map.put(31, SOLVED);
        map.put(32, NO_CLASS_CANCEL);
        map.put(33, FIRST_CLASS_CANCEL);
        map.put(34, MANY_CLASS_CANCEL);
        map.put(20, FINISHED);
        map.put(-1, UNCOMMENT);
        map.put(30, ALL_FINISHED_THREE_LATER);
    }

    private OrderStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer id) {
        return map.get(id).getNote();
    }

    public static List<OrderStatus> getSearchableList() {
        return searchableList;
    }
}

