/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgAppLoginLogDao;
import com.baijia.tianxiao.dal.org.extractors.StatisticsExtractor;
import com.baijia.tianxiao.dal.org.po.OrgAppLoginLog;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年4月21日
 * @desc
 */
@Repository
public class OrgAppLoginLogDaoIml extends JdbcTemplateDaoSupport<OrgAppLoginLog> implements OrgAppLoginLogDao {

    @Override
    public Map<Long, Integer> getOrgAppLoginTotal(Integer tid, Date startDate, Date endDate,
        List<Long> TianxiaoOrgIds) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql =
            "select count(id) as count,user_id as org_id from cdb.org_app_login_log where user_id in (:orgIds) ";
        if (startDate != null && endDate != null) {
            sql += " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql += " GROUP BY user_id";
        return this.getNamedJdbcTemplate().query(sql, param, new StatisticsExtractor());
    }

    @Override
    public Map<String, Integer> getOrgLoginMap(Date startTime, Date endTime, List<Long> TianxiaoOrgIds) {
        
        Map<String, Object> param = new HashMap<>();
        param.put("orgIds", TianxiaoOrgIds);
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        
        String sql =
            "select count(distinct(user_id)) count, DATE_FORMAT(create_time,'%y-%m-%d') 'createTime' from cdb.org_app_login_log where user_id in (:orgIds) "
            + " and create_time>=:startTime and create_time<=:endTime ";
        
        sql += "group by MONTH(create_time),DAY(create_time)";
        
        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<String, Integer>>() {

            @Override
            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<String, Integer> map = new HashMap<>();
                while(rs.next()){
                    String date = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    map.put(date, count);
                }
                return map;
            }
        });
    }

}
