package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.VideoCourseDao;
import com.baijia.tianxiao.dal.course.po.VideoCourse;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Repository("videoCourseDao")
public class VideoCourseDaoImpl extends JdbcTemplateDaoSupport<VideoCourse> implements VideoCourseDao {

    /**
     * @param entityClass
     */
    public VideoCourseDaoImpl() {
        super(VideoCourse.class);
    }

    @Override
    public List<VideoCourse> getTeacherVideoCourse(List<Teacher> teacherList, int orderType, String subjectIds) {
        final List<VideoCourse> result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(teacherList)) {
            return result;
        }
        StringBuffer teacherUids = new StringBuffer();
        for (Teacher teacher : teacherList) {
            teacherUids.append(teacher.getUserId()).append(",");
        }
        teacherUids.deleteCharAt(teacherUids.length() - 1);
        // 查询仅包括已经发布的
        String sql =
            "select id,name,number,user_id,extend_status,rank,page_view,transform,subject_id from cdb.video_course where status=1 and verify_status=1 and user_id in("
                + teacherUids + ")";
        if (StringUtils.isNotEmpty(subjectIds)) {
            sql = sql + " and subject_id in(:subjectIds) ";
        }
        if (orderType == 0) {
            sql = sql + " order by id desc ";
        } else if (orderType == 1) {
            sql = sql + " order by rank desc ";
        } else if (orderType == 2) {
            sql = sql + " order by rank asc ";
        } else if (orderType == 3) {
            sql = sql + " order by page_view desc ";
        } else if (orderType == 4) {
            sql = sql + " order by page_view asc ";
        } else if (orderType == 5) {
            sql = sql + " order by transform desc ";
        } else if (orderType == 6) {
            sql = sql + " order by transform asc ";
        }

        Map<String, Object> paramMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty(subjectIds)) {
            String[] subArray = StringUtils.split(subjectIds, "|");
            List<String> subjectList = Lists.newArrayList();
            for (String s : subArray) {
                subjectList.add(s);
            }
            paramMap.put("subjectIds", subjectList);
        }
        log.info("videoCourseQuery,sql=" + sql);
        getNamedJdbcTemplate().query(sql, paramMap, new ResultSetExtractor<List<VideoCourse>>() {

            @Override
            public List<VideoCourse> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    VideoCourse course = new VideoCourse();
                    course.setId(rs.getLong("id"));
                    course.setName(rs.getString("name"));
                    course.setNumber(rs.getLong("number"));
                    course.setUserid(rs.getLong("user_id"));
                    course.setExtendStatus(rs.getInt("extend_status"));
                    course.setRank(rs.getInt("rank"));
                    course.setPageView(rs.getInt("page_view"));
                    course.setTransform(rs.getInt("transform"));
                    course.setSubjectId(rs.getString("subject_id"));
                    result.add(course);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public int getMaxId() {
        SingleSqlBuilder<VideoCourse> builder = createSqlBuilder();
        builder.max("id");
        Integer maxId = queryForObject(builder, Integer.class);
        if (maxId != null) {
            return maxId;
        } else {
            return 0;
        }
    }

    @Override
    public VideoCourse getByNumber(long number) {
        SingleSqlBuilder<VideoCourse> builder = createSqlBuilder();
        builder.eq("number", number);
        return uniqueResult(builder);
    }

    @Override
    public List<VideoCourse> getVideoCourseList(Collection<Long> courseNumbers) {
        SingleSqlBuilder<VideoCourse> builder = createSqlBuilder();
        builder.in("number", courseNumbers);
        return queryList(builder);
    }
}
