/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.course.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.course.po.ClassCourseSchedule;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @author shanyu
 * @version 1.0
 * @title ClassCourseScheduleDao
 * @desc TODO
 * @date 2015年12月7日
 */

public interface ClassCourseScheduleDao extends CommonDao<ClassCourseSchedule> {
    /**
     * 获取课程对应的课次
     *
     * @param time      (time不为空时表示课节结束时间早于改时间点的课次数)
     * @param orgNumber
     * @return
     */
    Map<Long, Integer> getCourseTimeMap(Collection<Long> courseNumbers, Date time, Long orgNumber);

    /**
     * 获取课程安排列表
     *
     * @param time
     * @param orgNumber
     * @return
     */
    List<ClassCourseSchedule> getCoursseSchedule(Collection<Long> courseNumbers, Date time, Long orgNumber,
                                                 String... queryProps);
}
