/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.constant;

import com.baijia.tianxiao.dal.constant.ChargeUnit;

public enum ChargeType {
    BY_OTHER(-1, "\u672a\u77e5"),
    BY_PERIODS(1, "\u6309\u671f"),
    BY_CLASSHOUR(2, "\u6309\u8bfe\u65f6");

    private Integer code;
    private String label;

    private ChargeType(int code, String label) {
        this.code = code;
        this.label = label;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public static ChargeType getByCode(int code) {
        for (ChargeType p : ChargeType.values()) {
            if (p.getCode() != code) continue;
            return p;
        }
        return null;
    }

    public static boolean chargeByPeriods(int chargeType, int chargeUnit) {
        return chargeType == BY_PERIODS.getCode();
    }

    public static boolean chargeByClassHour(int chargeType, int chargeUnit) {
        return chargeType == BY_CLASSHOUR.getCode() && chargeUnit != ChargeUnit.BY_TIMES.getCode();
    }

    public static boolean chargeByTimes(int chargeType, int chargeUnit) {
        return chargeType == BY_CLASSHOUR.getCode() && chargeUnit == ChargeUnit.BY_TIMES.getCode();
    }
}

