/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.user.dao.impl;

import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class UserDaoImpl
extends JdbcTemplateDaoSupport<User>
implements UserDao {
    private static final Logger log = LoggerFactory.getLogger(UserDaoImpl.class);

    public UserDaoImpl() {
        super(User.class);
    }

    @Override
    public User getByNumber(@NonNull Long number, String ... queryProps) {
        if (number == null) {
            throw new NullPointerException("number");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("number", (Serializable)number);
        return (User)this.uniqueResult(builder);
    }

    @Override
    public List<User> getByNumbers(@NonNull Collection<Long> numbers, final String ... queryProps) {
        if (numbers == null) {
            throw new NullPointerException("numbers");
        }
        if (CollectionUtils.isEmpty(numbers)) {
            log.warn("numbers is empty");
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(numbers, (BatchQueryCallback)new BatchQueryCallback<Long, List<User>>(){

            public List<User> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = UserDaoImpl.this.createSqlBuilder(queryProps);
                builder.in("number", querySet);
                return UserDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public User getByMobile(@NonNull String mobile, String ... queryProps) {
        if (mobile == null) {
            throw new NullPointerException("mobile");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("mobile", (Serializable)((Object)mobile));
        return (User)this.uniqueResult(builder);
    }

    @Override
    public List<User> getByMobiles(@NonNull Collection<String> mobiles, final String ... queryProps) {
        if (mobiles == null) {
            throw new NullPointerException("mobiles");
        }
        if (CollectionUtils.isEmpty(mobiles)) {
            log.warn("mobiles is empty");
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(mobiles, (BatchQueryCallback)new BatchQueryCallback<String, List<User>>(){

            public List<User> doQuery(Collection<String> querySet) {
                SingleSqlBuilder builder = UserDaoImpl.this.createSqlBuilder(queryProps);
                builder.in("mobile", querySet);
                return UserDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public boolean exist(@NonNull String mobile) {
        if (mobile == null) {
            throw new NullPointerException("mobile");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("mobile", (Serializable)((Object)mobile));
        Number id = (Number)this.queryForObject(builder, Long.class);
        return id.intValue() > 0;
    }

    @Override
    public List<User> queryByUserIds(Collection<Long> userIds, final String ... queryProps) {
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<User>>(){

            public List<User> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = UserDaoImpl.this.createSqlBuilder(queryProps);
                builder.in("id", querySet);
                return UserDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public Map<Long, User> getMapByIds(Collection<Long> userIds, String ... queryProps) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<User> users = this.queryByUserIds(userIds, queryProps);
        if (CollectionUtils.isEmpty(users)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (User user : users) {
            result.put(Long.valueOf(user.getId()), user);
        }
        return result;
    }

    @Override
    public Map<Long, String> getUserMobile(Collection<Long> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        List<User> users = this.queryByUserIds(ids, "id", "mobile");
        if (CollectionUtils.isEmpty(users)) {
            return Collections.emptyMap();
        }
        return CollectorUtil.collectMap(users, (Function)new Function<User, Long>(){

            public Long apply(User from) {
                return from.getId();
            }
        }, (Function)new Function<User, String>(){

            public String apply(User from) {
                return from.getMobile();
            }
        });
    }

    @Override
    public List<User> getUsersByMobile(String mobile, String ... queryPros) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryPros);
        builder.like("mobile", (Serializable)((Object)mobile), MatchMode.START);
        return this.queryList(builder);
    }
}

