/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.constant;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public enum ChargeUnit {
    BY_OTHER(-1, "\u672a\u77e5"),
    BY_TIMES(1, "\u6b21"),
    BY_HOUR(2, "\u5c0f\u65f6"),
    BY_HALF_HOUR(3, "\u534a\u5c0f\u65f6"),
    BY_MINUTE(4, "\u5206\u949f");

    private Integer code;
    private String desc;
    private static Map<Integer, ChargeUnit> map;

    public static ChargeUnit getByDesc(String desc) {
        if (MapUtils.isNotEmpty(map)) {
            for (ChargeUnit obj : map.values()) {
                if (!obj.getDesc().equals(desc)) continue;
                return obj;
            }
        }
        return null;
    }

    public static String getDescRegex() {
        if (MapUtils.isNotEmpty(map)) {
            String result = null;
            StringBuilder builder = new StringBuilder();
            for (ChargeUnit obj : map.values()) {
                builder.append(obj.getDesc());
                builder.append("|");
            }
            result = builder.toString();
            result = result.substring(0, result.length() - 1);
            return result;
        }
        return null;
    }

    private ChargeUnit(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ChargeUnit getByCode(int code) {
        return map.get(code);
    }

    public static boolean isByTime(int type) {
        return type == ChargeUnit.BY_HALF_HOUR.code || type == ChargeUnit.BY_HOUR.code || type == ChargeUnit.BY_MINUTE.code;
    }

    public static boolean isByTimes(int type) {
        return type == ChargeUnit.BY_TIMES.code;
    }

    public static List<Integer> listByTimeCode() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (MapUtils.isNotEmpty(map)) {
            for (ChargeUnit obj : map.values()) {
                if (!ChargeUnit.isByTime(obj.getCode())) continue;
                list.add(obj.getCode());
            }
        }
        return list;
    }

    public static List<ChargeUnit> listByTimeEnum() {
        ArrayList<ChargeUnit> list = new ArrayList<ChargeUnit>();
        if (MapUtils.isNotEmpty(map)) {
            for (ChargeUnit obj : map.values()) {
                if (!ChargeUnit.isByTime(obj.getCode())) continue;
                list.add(obj);
            }
        }
        return list;
    }

    public static List<Integer> listByTimesCode() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (MapUtils.isNotEmpty(map)) {
            for (ChargeUnit obj : map.values()) {
                if (!ChargeUnit.isByTimes(obj.getCode())) continue;
                list.add(obj.getCode());
            }
        }
        return list;
    }

    static {
        map = Maps.newHashMap();
        for (ChargeUnit p : ChargeUnit.values()) {
            map.put(p.getCode(), p);
        }
    }
}

