/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.user.po;

import com.baijia.tianxiao.dto.BaseDto;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @author cxm
 * @version 1.0
 * @title Teacher
 * @desc TODO
 * @date 2015年9月7日
 */
@Data
@Table(name = "teacher_modified", catalog = "cdb" )
@Entity
public class TeacherModified extends BaseDto {

    @Id
    @GeneratedValue
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "realname")
    private String realName;

    @Column(name = "nickname")
    private String nickName;

    @Column(name = "sex")
    private Integer sex;

    @Column(name = "birthday")
    private Date birthday;

    @Column(name = "verify_status")
    private Integer verifyStatus;

    @Column(name = "organization_id")
    private Long orgId;

    @Column(name = "avatar")
    private Long avatar;

    @Column(name = "is_valid")
    private boolean isValid;

    @Column(name = "private_protected")
    private Integer privateProtected = 0;

    @Column(name = "other_info")
    private String otherInfo;

    @Column(name = "short_introduce")
    private String shortIntroduce;

    @Column(name = "school_age")
    private int schoolAge;

    @Column(name = "created_at")
    private Date createdAt;

    @Column(name = "updated_at")
    private Date updatedAt;

}
