/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2014 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.constant;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

/**
 * @title OrderStatus
 * @desc 所有状态集合 (course_purchase, order_info)
 * @author wangzhigang
 * @date 2014年9月29日
 * @version 1.0
 */
public enum OrderStatus {
    UNCOMMENT(-1, "待评价"), //order_info中status=20或者30才可作为待评价的前提条件
    ING(0, "待支付"), // course_purchase
    SUCC(1, "付款成功"), // course_purchase
    FAIL(2, "支付失败"), // course_purchase
    UNPAID_CANCEL(3, "已取消(未支付)"), // course_purchase
    EXPIRED(4, "7天未支付,自动关闭"), // course_purchase
    PAID_CANCEL(5, "已取消(已支付)"), // course_purchase

    UNDER_WAY(10, "进行中"), // order_info: A0
    APPEALING(40, "申诉中"), // order_info: C0
    SOLVED(31, "已处理"), // order_info: D1
    NO_CLASS_CANCEL(32, "已取消(未上课)"), // order_info: D2
    FIRST_CLASS_CANCEL(33, "已取消(首次课取消)"), // order_info: D3
    MANY_CLASS_CANCEL(34, "已取消(上课后)"), // order_info: D4
    FINISHED(20, "已完成"), // order_info: B0
    ALL_FINISHED_THREE_LATER(30, "所有课时完成3天后") //order_info: D0
    ;

    private static List<OrderStatus> searchableList = Lists.newArrayList();
    private static Map<Integer, OrderStatus> map = Maps.newHashMap();

    static {
        searchableList.add(ING);
        searchableList.add(EXPIRED);
        searchableList.add(UNPAID_CANCEL);
        searchableList.add(UNDER_WAY);
        searchableList.add(APPEALING);
        searchableList.add(SOLVED);
        searchableList.add(NO_CLASS_CANCEL);
        searchableList.add(FIRST_CLASS_CANCEL);
        searchableList.add(MANY_CLASS_CANCEL);
        searchableList.add(FINISHED);
        
        searchableList.add(ALL_FINISHED_THREE_LATER);
        searchableList.add(UNCOMMENT);

        map.put(0, ING);
        map.put(4, EXPIRED);
        map.put(3, UNPAID_CANCEL);
        map.put(10, UNDER_WAY);
        map.put(40, APPEALING);
        map.put(31, SOLVED);
        map.put(32, NO_CLASS_CANCEL);
        map.put(33, FIRST_CLASS_CANCEL);
        map.put(34, MANY_CLASS_CANCEL);
        map.put(20, FINISHED);
        
        map.put(-1, UNCOMMENT);
        map.put(30, ALL_FINISHED_THREE_LATER);
    }

    private int code;
    private String note;

    private OrderStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer id) {
        return map.get(id).getNote();
    }

    public static List<OrderStatus> getSearchableList() {
        return searchableList;
    }
}
