package com.baijia.tianxiao.dal.constant;

import java.util.Map;

import org.apache.commons.collections4.MapUtils;

import com.google.common.collect.Maps;

public enum ChargeUnit {
    BY_OTHER(-1,"未知"),      //历史数据默认未知类型
    BY_TIMES(1,"次"), // 按次
    BY_HOUR(2,"小时"), // 按课时
    BY_HALF_HOUR(3,"半小时"), // 按课时
    ;
    private Integer code;
    private String desc;
    
    private static Map<Integer, ChargeUnit> map = Maps.newHashMap();

    static {
        for (ChargeUnit p : values()) {
            map.put(p.getCode(), p);
        }
    }
    
    public static ChargeUnit getByDesc(String desc) {
    	if( MapUtils.isNotEmpty(map) ){
    		for(ChargeUnit obj:map.values()){
    			if(obj.getDesc().equals(desc)){
    				return obj;
    			}
    		}
    	}
    	return null;
    }

    public static String getDescRegex(){
    	if( MapUtils.isNotEmpty(map) ){
    		String result = null;
    		StringBuilder builder = new StringBuilder();
    		
    		for(ChargeUnit obj:map.values()){
    			builder.append(obj.getDesc());
    			builder.append("|");
    		}
    		result = builder.toString();
    		result = result.substring(0,result.length()-1);
    		return result;
    	}
    	return null;
    }
    
    
    ChargeUnit(int code,String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code.intValue();
    }
    
    public String getDesc() {
        return this.desc;
    }

    public static boolean isByTime(int type){
        if(type==BY_HALF_HOUR.code || type==BY_HOUR.code){
            return true;
        }else {
            return false;
        }
    }

    public static ChargeUnit getByCode(int code){
        return map.get(code);
    }
    
}