/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.util;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNumberUtil {
    private static Logger logger = LoggerFactory.getLogger(SerialNumberUtil.class);
    public static final int MAX = 99999999;
    public static final int COURSE_MAX = 99999999;
    private static final int[] bitMap;
    private static final int SUFFIX = 9;

    static {
        int[] nArray = new int[26];
        nArray[0] = 11;
        nArray[1] = 8;
        nArray[2] = 4;
        nArray[4] = 16;
        nArray[5] = 14;
        nArray[6] = 22;
        nArray[7] = 7;
        nArray[8] = 3;
        nArray[9] = 5;
        nArray[10] = 13;
        nArray[11] = 18;
        nArray[12] = 24;
        nArray[13] = 25;
        nArray[14] = 23;
        nArray[15] = 10;
        nArray[16] = 1;
        nArray[17] = 12;
        nArray[18] = 6;
        nArray[19] = 21;
        nArray[20] = 17;
        nArray[21] = 2;
        nArray[22] = 15;
        nArray[23] = 9;
        nArray[24] = 19;
        nArray[25] = 20;
        bitMap = nArray;
    }

    public static int generateNumber(int id, int max) {
        SerialNumberUtil.assertId(id, max);
        int encodedId = SerialNumberUtil.encode(id, max);
        int number = SerialNumberUtil.allocateStart(max) + encodedId;
        int serialNumber = number * 10 + 9;
        logger.info("generate serialNumber-id:{},encodedId;{},number:{},serailNumber:{}", new Object[]{id, encodedId, number, serialNumber});
        return serialNumber;
    }

    public static long generateNumber(int id, int max, int suffix) {
        SerialNumberUtil.assertId(id, max);
        int encodedId = SerialNumberUtil.encode(id, max);
        int number = SerialNumberUtil.allocateStart(max) + encodedId;
        Long serialNum = Long.parseLong(String.valueOf(number)) * 100L + (long)suffix;
        return serialNum;
    }

    private static int allocateMax(int max) {
        return (int)Math.pow(2.0, SerialNumberUtil.power(max)) - 1;
    }

    private static int power(int max) {
        return (int)(Math.log(max) / Math.log(2.0));
    }

    private static int allocateStart(int max) {
        return max - (int)Math.pow(2.0, SerialNumberUtil.power(max)) + 1;
    }

    private static void assertId(int id, int max) {
        int allocateMax = SerialNumberUtil.allocateMax(max);
        if (id > allocateMax) {
            throw new RuntimeException("generateNumber by id:" + id + " out of range [1," + allocateMax + "] ...");
        }
    }

    private static int encode(int id, int max) {
        int encodedId = 0;
        int i = 0;
        while (i < SerialNumberUtil.power(max)) {
            int tmp = id >> i & 1;
            encodedId |= tmp << bitMap[i];
            ++i;
        }
        return encodedId;
    }

    private static int[] mapBit(int power) {
        int[] bit = new int[power + 1];
        int i = 0;
        while (i <= power / 2) {
            if (i % 2 == 0) {
                bit[i] = power - i;
                bit[power - i] = i;
            } else {
                bit[i] = i;
                bit[power - i] = power - i;
            }
            ++i;
        }
        return bit;
    }

    public static void main(String[] args) {
        System.out.println(SerialNumberUtil.power(99999999));
        System.out.println(Arrays.toString(bitMap));
        int i = 0;
        while (i < 1000000) {
            System.out.println(SerialNumberUtil.generateNumber(i, 99999999, 4));
            i += 1000;
        }
    }
}

