package com.baijia.tianxiao.dal.org.extractors;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by liuxp on 16/4/25.
 */
public class StatisticsExtractor implements ResultSetExtractor<Map<Long, Integer>> {
    @Override
    public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
        Map<Long, Integer> map = new HashMap<>();
        while (rs.next()) {
            Long orgId = rs.getLong("org_id");
            Integer count = rs.getInt("count");
            map.put(orgId, count);
        }
        return map;
    }
}
