/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgCourseTeacherDaoImpl
extends JdbcTemplateDaoSupport<OrgCourseTeacher>
implements OrgCourseTeacherDao {
    public OrgCourseTeacherDaoImpl() {
        super(OrgCourseTeacher.class);
    }

    @Override
    public List<OrgCourseTeacher> getTeacher(Long orgId, Long courseId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgCourseId", (Serializable)courseId);
        builder.asc("createTime");
        return this.queryList(builder);
    }

    @Override
    public Integer getTeacherCourseCount(Long teacherId) {
        Preconditions.checkArgument((teacherId != null && teacherId > 0L ? 1 : 0) != 0, (Object)"teacherId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("userId", (Serializable)teacherId);
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgCourseTeacher> getCourseTeachers(Long userId) {
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"userId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)userId);
        return this.queryList(builder);
    }

    @Override
    public List<String> getTeacherNames(Long courseId) {
        String sql = "select ct.nickname, ct.realname from cdb.org_course_teacher ot,cdb.teacher ct where ot.org_course_id=:orgCourseId and ot.user_id=ct.user_id";
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("orgCourseId", courseId);
        List names = this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String nickname = rs.getString("nickname");
                String realname = rs.getString("realname");
                return StringUtils.isNotBlank((CharSequence)realname) ? realname : (StringUtils.isNotBlank((CharSequence)nickname) ? nickname : "");
            }
        });
        return names;
    }

    @Override
    public List<OrgCourseTeacher> getOrgCourseTeacher(Collection<Long> courseIds, PageDto pageDto) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgCourseId", courseIds);
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public int delTeachersFromCourse(Long courseId, Collection<Long> teacherIds) {
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgCourseId", (Serializable)courseId);
        if (CollectionUtils.isNotEmpty(teacherIds)) {
            builder.in("userId", teacherIds);
        }
        return this.delete(builder);
    }

    @Override
    public Map<Long, List<Long>> getTeacherMap(Collection<Long> courseIds) {
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List list = (List)queryTemplate.batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgCourseTeacher>>(){

            public List<OrgCourseTeacher> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseTeacherDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("orgCourseId", querySet);
                return OrgCourseTeacherDaoImpl.this.queryList(builder);
            }
        });
        Map teacherIdMap = CollectorUtil.group((Collection)list, (Function)new Function<OrgCourseTeacher, Long>(){

            public Long apply(OrgCourseTeacher arg0) {
                return arg0.getOrgCourseId();
            }
        }, (Function)new Function<OrgCourseTeacher, Long>(){

            public Long apply(OrgCourseTeacher arg0) {
                return arg0.getUserId();
            }
        });
        return teacherIdMap;
    }

    @Override
    public List<Long> getTeacherIdsByCourseId(Long courseId) {
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("orgCourseId", (Serializable)courseId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getCourseIdByTeacherId(Long userId) {
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"userId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"orgCourseId"});
        builder.eq("userId", (Serializable)userId);
        return this.queryForList(builder, Long.class);
    }

    @Override
    public Map<Long, Integer> getTeacherCount(Collection<Long> courseIds) {
        if (CollectionUtils.isEmpty(courseIds)) {
            return Maps.newHashMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(courseIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Integer>>(){

            public Map<Long, Integer> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseTeacherDaoImpl.this.createSqlBuilder(new String[]{"orgCourseId"});
                builder.count("id", "num");
                builder.in("orgCourseId", querySet);
                builder.group("orgCourseId");
                final HashMap result = Maps.newHashMap();
                OrgCourseTeacherDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("orgCourseId"), rs.getInt("num"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public List<Long> getTeacherCourseIds(Long teacherId, PageDto pageDto) {
        Preconditions.checkArgument((teacherId != null ? 1 : 0) != 0, (Object)"teacherId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"orgCourseId"});
        builder.eq("userId", (Serializable)teacherId);
        builder.setPage(pageDto);
        builder.desc("createTime");
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<Long> getCourseIdsByteacherIds(Collection<Long> teacherIds) {
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(teacherIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<Long>>(){

            public List<Long> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgCourseTeacherDaoImpl.this.createSqlBuilder(new String[]{"orgCourseId"});
                builder.in("userId", querySet);
                return OrgCourseTeacherDaoImpl.this.queryForList(builder, Long.class);
            }
        });
    }

    @Override
    public List<Long> getOrgTeacherCourseIds(Long orgId, Long userId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"teacherId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"orgCourseId"});
        builder.eq("userId", (Serializable)userId);
        return this.queryForList(builder, Long.class);
    }
}

