/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.course.dao.impl;

import com.baijia.tianxiao.dal.course.dao.VideoCourseDao;
import com.baijia.tianxiao.dal.course.po.VideoCourse;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="videoCourseDao")
public class VideoCourseDaoImpl
extends JdbcTemplateDaoSupport<VideoCourse>
implements VideoCourseDao {
    private static final Logger log = LoggerFactory.getLogger(VideoCourseDaoImpl.class);

    public VideoCourseDaoImpl() {
        super(VideoCourse.class);
    }

    @Override
    public List<VideoCourse> getTeacherVideoCourse(List<Teacher> teacherList, int orderType, String subjectIds) {
        final ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(teacherList)) {
            return result;
        }
        StringBuffer teacherUids = new StringBuffer();
        for (Teacher teacher : teacherList) {
            teacherUids.append(teacher.getUserId()).append(",");
        }
        teacherUids.deleteCharAt(teacherUids.length() - 1);
        String sql = "select id,name,number,user_id,extend_status,rank,page_view,transform,subject_id from cdb.video_course where status=1 and verify_status=1 and user_id in(" + teacherUids + ")";
        if (StringUtils.isNotEmpty((CharSequence)subjectIds)) {
            sql = String.valueOf(sql) + " and subject_id in(:subjectIds) ";
        }
        if (orderType == 0) {
            sql = String.valueOf(sql) + " order by id desc ";
        } else if (orderType == 1) {
            sql = String.valueOf(sql) + " order by rank desc ";
        } else if (orderType == 2) {
            sql = String.valueOf(sql) + " order by rank asc ";
        } else if (orderType == 3) {
            sql = String.valueOf(sql) + " order by page_view desc ";
        } else if (orderType == 4) {
            sql = String.valueOf(sql) + " order by page_view asc ";
        } else if (orderType == 5) {
            sql = String.valueOf(sql) + " order by transform desc ";
        } else if (orderType == 6) {
            sql = String.valueOf(sql) + " order by transform asc ";
        }
        HashMap paramMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)subjectIds)) {
            String[] subArray = StringUtils.split((String)subjectIds, (String)"|");
            ArrayList subjectList = Lists.newArrayList();
            String[] stringArray = subArray;
            int n = subArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                subjectList.add(s);
                ++n2;
            }
            paramMap.put("subjectIds", subjectList);
        }
        log.info("videoCourseQuery,sql=" + sql);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<List<VideoCourse>>(){

            public List<VideoCourse> extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    VideoCourse course = new VideoCourse();
                    course.setId(rs.getLong("id"));
                    course.setName(rs.getString("name"));
                    course.setNumber(rs.getLong("number"));
                    course.setUserid(rs.getLong("user_id"));
                    course.setExtendStatus(rs.getInt("extend_status"));
                    course.setRank(rs.getInt("rank"));
                    course.setPageView(rs.getInt("page_view"));
                    course.setTransform(rs.getInt("transform"));
                    course.setSubjectId(rs.getString("subject_id"));
                    result.add(course);
                }
                return result;
            }
        });
        return result;
    }

    @Override
    public int getMaxId() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.max("id");
        Integer maxId = (Integer)this.queryForObject(builder, Integer.class);
        if (maxId != null) {
            return maxId;
        }
        return 0;
    }

    @Override
    public VideoCourse getByNumber(long number) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("number", (Serializable)Long.valueOf(number));
        return (VideoCourse)this.uniqueResult(builder);
    }
}

