
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www.authentication.handler;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.biz.www.constant.BizConstant;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.pcAuthority.dao.TXPermissionDao;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

/**
 * @title TxCascadeAccountAuthenticateHandler
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年8月24日
 * @version 1.0
 */
@Slf4j
public class TxCascadeAccountAuthenticateHandler extends AbstractAuthenticateHandler {
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private TXPermissionDao txPermissionDao;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    @Override
    protected boolean doAuthentication(Credential credential, Map<String, Object> options) throws BussinessException {
        TXCascadeCredential txCascadeCredential = txCascadeCredentialDao.getByMobile(credential.getMobile());
        if (txCascadeCredential == null) {
            return false;
        }
        // 临时密码
        Boolean isTemp = false;
        try {
            String tempPwd = MemcachedUtil.get("uniq_temp_tx_password_" + credential.getMobile());
            if (StringUtils.isNoneBlank(tempPwd)) {
                if (tempPwd.equals(credential.getPassword())) {
                    MemcachedUtil.delete("uniq_temp_tx_password_" + credential.getMobile());
                    isTemp = true;
                }
            }
        } catch (TimeoutException | InterruptedException | MemcachedException e) {
            log.error("get temp pwd error!mobile:{}", credential.getMobile(), e);
        }
        OrgAccount orgAccount = null;
        if (options.get(ORG_ACCOUNT_KEY) != null) {
            orgAccount = (OrgAccount) options.get(ORG_ACCOUNT_KEY);
        }

        try {
            if (!isTemp) {

                if (orgAccount != null) {
                    if (!PasswordUtil.validatePassword(credential.getPassword(), orgAccount.getPassword())) {
                        return false;
                    }
                } else {
                    if (!PasswordUtil.validatePassword(credential.getPassword(), txCascadeCredential.getPassword())) {
                        return false;
                    }
                }
            }
        } catch (Exception e) {
            log.info("login pwd:{},hash:{},error!:{}", credential.getPassword(), txCascadeCredential.getPassword(), e);
            return false;
        }

        options.put(TX_CASCADE_CREDENTIAL_KEY, txCascadeCredential);
        return true;

    }

    @Override
    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos,
        Map<String, Object> options) throws BussinessException, Exception {
        TXCascadeCredential txCascadeCredential = (TXCascadeCredential) options.get(TX_CASCADE_CREDENTIAL_KEY);
        List<TXCascadeAccount> txCascadeAccounts =
            txCascadeAccountDao.getValidAccountsByCredentialId(txCascadeCredential.getId());
        if (CollectionUtils.isEmpty(txCascadeAccounts)) {
            return false;
        }
        Map<Integer, TXLoginAccountDto> existDto = Maps.newHashMap();
        log.info("txCascadeAccounts:{}", txCascadeAccounts);
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            OrgAccount orgAccount = orgAccountService.getOrgAccountById(txCascadeAccount.getOrgId());
            // 总校区
            boolean hasTXPermission = hagService.hasPermission(orgAccount.getNumber(), BizConf.DEFAULT_TYPE,
                BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER);
            if (!hasTXPermission) {
                log.info("no hag txCascadeAccount:{}", txCascadeAccount);
                continue;
            }
            TXAccount txAccount = txAccountService.getByOrgId(orgAccount.getId());
            String auth_token = null;
            // 两种情况为null，1.分校区 2.禁用了，第2种跳过
            if (txAccount == null) {
                auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), txCascadeAccount.getId(), null, txCascadeAccount.getAccountVersion(),super.TX_APP_ENVIRONMENT);
                //
                OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
                txAccount = txAccountService.getByOrgId(orgSubAccount.getPid());
                // 禁用的主帐号，查不出来
                // 大众版不允许子帐号
                if (txAccount == null || txAccount.getVipLevel().intValue() == TXAccountType.DAZHONG.getCode()) {
                    log.info("txAccount invalid:{}", txAccount);
                    continue;
                }
            } else {
                if (txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode()) {
                    log.info("txAccount invalid111:{}", txAccount);
                    continue;
                }
                // 总校主管允许登录pc,txAccount.id 是登录pc标识
                if (txCascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
                    auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), txCascadeAccount.getId(),
                        txAccount.getId(), txCascadeAccount.getAccountVersion(),super.TX_APP_ENVIRONMENT);
                } else {
                    auth_token =
                        EncryptUtils.txStrEncode(orgAccount.getId(), txCascadeAccount.getId(), null, txCascadeAccount.getAccountVersion(),super.TX_APP_ENVIRONMENT);
                }
            }

            TXLoginAccountDto dto = null;
            if (existDto.containsKey(orgAccount.getId())) {
                dto = existDto.get(orgAccount.getId());
            } else {
                OrgInfo orgInfo = orgInfoService.getOrgInfoByOrgId(orgAccount.getId());
                dto = loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
                List<RoleDto> roleDtos = Lists.newArrayList();
                dto.setHasRoles(roleDtos);
                existDto.put(orgAccount.getId(), dto);
                loginDtos.add(dto);
            }
            dto.setDataAccountType(BizConf.NORMAL_ACCOUNT);
            RoleDto roleDto = new RoleDto();
            roleDto.setId(txCascadeAccount.getId());
            roleDto.setNickName(txCascadeCredential.getName());
            roleDto.setType(txCascadeAccount.getAccountType());
            roleDto.setAuth_token(auth_token);
            roleDto.setMobile(txCascadeCredential.getMobile());
            // 权限
            TxAccountPermissionsDto txAccountPermissionDto =
                txAccountPermissionService.universalGetPermissions(orgAccount.getId(), txCascadeAccount.getId());
            roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
            if (StringUtils.isNotBlank(txCascadeCredential.getAvatar())) {
                roleDto.setRoleAvatar(txCascadeCredential.getAvatar());
            } else {
                roleDto.setRoleAvatar(BizConstant.DEFAULT_CASCADE_AVATAR);
            }
            dto.getHasRoles().add(roleDto);
        }

        return true;
    }

}
