
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.www.constant;

/**
 * @title TxPermission
 * @desc 一级功能编号：1-9 二级、三级。。。功能编号：01-99
 * @author caoliang
 * @date 2016年4月19日
 * @version 1.0
 */

public enum ExpTxPermission {
    PARENT("0",0,null,""),
    ERP("1",1,PARENT,"ERP"),
    CRM("2",1,PARENT,"CRM"),
    SEM("3",1,PARENT,"营销"),
    ME("4",1,PARENT,"我"),
    PAY("06",2,ERP,"资金"),
    PAY_PWD("01",3,PAY,"校验输入的支付密码"),
    DRAW("02",3,PAY,"提现"),
    SET_PAY_PWD("03",3,PAY,"设置支付密码"),
    GATHERING("03",2,ERP,"收款"),
    GATHERING_H5("02",3,GATHERING,"收款页面"),
    SETTING("06",2,ME,"设置"),
    ORG_TEL("03",3,SETTING,"机构电话"),
    ORG_TEL_ADD("02",4,ORG_TEL,"添加机构电话"),
    ORG_TEL_EDIT("03",4,ORG_TEL,"编辑机构电话"),
    ORG_TEL_DEL("01",4,ORG_TEL,"删除机构电话");
    
    private String value;
    private int level;
    private ExpTxPermission parent;
    private String label;
    
    ExpTxPermission(String value, int level, ExpTxPermission parent, String label){
        this.value = value;
        this.level = level;
        this.parent = parent;
        this.label = label;
    }

    public String getValue() {
    
        return value;
    }

    public void setValue(String value) {
    
        this.value = value;
    }

    public int getLevel() {
    
        return level;
    }

    public void setLevel(int level) {
    
        this.level = level;
    }

    public ExpTxPermission getParent() {
    
        return parent;
    }

    public void setParent(ExpTxPermission parent) {
    
        this.parent = parent;
    }

    public String getLabel() {
    
        return label;
    }

    public void setLabel(String label) {
    
        this.label = label;
    }
    
    public static String getCompleteValue(ExpTxPermission permission){
        StringBuilder result = new StringBuilder();
        if(permission.getParent() == PARENT){
            return permission.getValue();
        }else{
            result.append(getCompleteValue(permission.getParent())).append(permission.getValue());
        }
        return result.toString();
    }
    
}

    