
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.LoginAppInfoContext;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTxtMsgService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

/**
 * @title LoginAccountDtoHelper
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年8月25日
 * @version 1.0
 */
@Component
@Slf4j
public class LoginAccountDtoHelper {

    // 获取新的IMToken
    public static final String NEW_IM_TOKEN = "1";
    // 获取已有的ImToken
    public static final String OLD_IM_TOKEN = "2";

    @Autowired
    private OrgTxtMsgService orgTxtMsgService;
    @Autowired
    private OrgPhotoService orgPhotoService;
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;
    @Autowired
    private OrgStudentDao orgStudentDAo;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    public TXLoginAccountDto buildLoginData(OrgAccount account, OrgInfo orgInfo) throws Exception {
        log.info("OrgInfo is :{} ", orgInfo);
        TXLoginAccountDto data = new TXLoginAccountDto();
        data.setShort_name(orgInfo.getShortName());
        data.setUser_id(account.getId());
        data.setUser_number(account.getNumber());
        data.setAudit_status(orgInfo.getAuditStatus());
        data.setHome_page(PropertiesReader.getValue("tianxiao", "TIANXIAO_M") + "i/" + account.getNumber());
        data.setAreaId(orgInfo.getAreaId());

        // 机构热线
        OrgTxtMsg hotLine = orgTxtMsgService.getOrgTxtByIdAndType(account.getId(), AuditColumType.PHONE.getValue());
        data.setHotline(hotLine == null ? null : hotLine.getValue());
        data.setAvatar(orgPhotoService.getPhotoUrlByOrgIdAndCategory(account.getId().longValue(), OrgImgType.ORG_LOGO));
        return data;
    }

    /**
     * 大众版版本限制
     * 
     * @return
     */
    public boolean validTXVersion(TXAccount txAccount, String version) {
        if (txAccount.getVipLevel().intValue() != TXAccountType.DAZHONG.getCode()) {
            return true;
        }
        String vReq = version.replace(".", "");
        String vBase = "153";
        for (int index = 0; index < vBase.length(); index++) {
            if (Integer.valueOf(String.valueOf(vBase.charAt(0))) < Integer.valueOf(String.valueOf(vReq.charAt(0)))) {
                // 首尾版本号已经大于1时，不做判断
                break;
            }
            if (Integer.valueOf(String.valueOf(vBase.charAt(1))) < Integer.valueOf(String.valueOf(vReq.charAt(1)))) {
                // 第二位尾版本号已经大于5时，不做判断
                break;
            }
            if (Integer.valueOf(String.valueOf(vBase.charAt(1))) < Integer.valueOf(String.valueOf(vReq.charAt(1)))) {
                // 第二位版本号已经大于4时，不做判断
                break;
            }
            Integer base = Integer.valueOf(String.valueOf(vBase.charAt(index)));
            Integer req = Integer.valueOf(String.valueOf(vReq.charAt(index)));
            if (base > req) {
                return false;
            }
        }
        return true;
    }

    public List<TXLoginAccountDto> transformLoginDtos(List<TXLoginAccountDto> loginDtos, String mobile) {
        if (GenericsUtils.isNullOrEmpty(loginDtos)) {
            return GenericsUtils.emptyList();
        }
        List<Integer> subOrgIds = Lists.newArrayList();
        TXAccount txAccount = null;
        if (GenericsUtils.notNullAndEmpty(mobile)) {
            txAccount = findMasterTXAccount(mobile);
        }
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            if (txAccount != null) {
                InitPageUtils.fillInitPageInfos(txAccount, tLoginAdto, tLoginAdto.getShort_name());
            }
            Integer user_id = tLoginAdto.getUser_id();
            subOrgIds.add(user_id);
        }
        List<TXLoginAccountDto> retNewLoginDtos = createAndSortTxLoginDtos(loginDtos, subOrgIds);

        return retNewLoginDtos;
    }

    public List<TXLoginAccountDto> transformLoginDtos(List<TXLoginAccountDto> loginDtos) {
        if (GenericsUtils.isNullOrEmpty(loginDtos)) {
            return GenericsUtils.emptyList();
        }
        List<Integer> subOrgIds = Lists.newArrayList();
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            Integer user_id = tLoginAdto.getUser_id();
            subOrgIds.add(user_id);
        }
        List<TXLoginAccountDto> retNewLoginDtos = createAndSortTxLoginDtos(loginDtos, subOrgIds);
        return retNewLoginDtos;
    }

    /**
     * @param loginDtos
     * @param subOrgIds
     * @return
     */
    private List<TXLoginAccountDto> createAndSortTxLoginDtos(List<TXLoginAccountDto> loginDtos,
        List<Integer> subOrgIds) {
        Set<TXLoginAccountDto> newLoginDtos = Sets.newHashSet();
        Map<Integer, Integer> studentCountMap = orgStudentDAo.getStudentCountMapByStatus(subOrgIds,
            StudentLessonStatus.findSubStatus(StudentLessonStatus.STUDYING.getStatus()));
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            newLoginDtos.addAll(createNewTXLoginAccountDto(tLoginAdto, studentCountMap.get(tLoginAdto.getUser_id())));
        }

        Set<Integer> isExistsSubRoleSet = Sets.newHashSet();
        for (TXLoginAccountDto tad : newLoginDtos) {
            int type = tad.getType();
            if (tad.isMasterSlaveOrg()) {
                if (type == RoleType.BRANCH_SCH_PRESIDENT.type) {
                    log.info("find TXLoginAccountDto :{} is a masterSlaveOrg ", tad);
                    isExistsSubRoleSet.add(tad.getUser_id());
                }
            }
        }
        for (Iterator<TXLoginAccountDto> iter = newLoginDtos.iterator(); iter.hasNext();) {
            TXLoginAccountDto next = iter.next();
            int type = next.getType();
            if ((type == RoleType.CHARAGE.type || type == RoleType.EMPLOYEE.type)
                && isExistsSubRoleSet.contains(next.getUser_id())) {
                log.info("find same org has multi roles , so will remove :{} ", next);
                iter.remove();
            }
        }
        List<TXLoginAccountDto> retNewLoginDtos = InitPageUtils.sortResult(newLoginDtos);
        return retNewLoginDtos;
    }

    /**
     * @param mobile
     * @return
     */
    public TXAccount findMasterTXAccount(String mobile) {
        OrgAccount accountByMobile = this.orgAccountDao.getAccountByMobile(mobile);
        if (accountByMobile != null) {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(accountByMobile.getId());
            Integer orgId = accountByMobile.getId();
            if (osa != null) {
                if (osa.getPid() != null && osa.getPid().intValue() != 0) {
                    orgId = osa.getPid();
                }
                return this.txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode());
            }
        }
        return null;
    }

    private static String ADDRESS_KEY = "address";
    private static String LOCATION_KEY = "location";
    private static String LOCATION_CITY_KEY = "locationCity";

    private List<TXLoginAccountDto> createNewTXLoginAccountDto(TXLoginAccountDto tLoginAdto, Integer studentCount) {
        List<TXLoginAccountDto> retList = Lists.newArrayList();
        List<RoleDto> hasRoles = tLoginAdto.getHasRoles();

        log.info("hasRoles's size is :{} ", hasRoles.size());

        String initOrgName = tLoginAdto.getInitOrgName();
        String orgLogo = tLoginAdto.getOrgLogo();
        String orgSlogan = tLoginAdto.getOrgSlogan();
        Integer infoFillStatus = tLoginAdto.getInfoFillStatus();

        Integer audit_status = tLoginAdto.getAudit_status();
        String shortName = tLoginAdto.getShort_name();
        String avatar = tLoginAdto.getAvatar();
        String hotline = tLoginAdto.getHotline();
        Integer user_id = tLoginAdto.getUser_id();
        String home_page = tLoginAdto.getHome_page();
        Integer dataAccountType = tLoginAdto.getDataAccountType();
        Integer userNumber = tLoginAdto.getUser_number();
        Map<String, String> locationInfos = getLocationInfos(userNumber);
        String address = locationInfos.get(ADDRESS_KEY);
        String location = locationInfos.get(LOCATION_KEY);
        String locationCity = locationInfos.get(LOCATION_CITY_KEY);
        String city = InitPageUtils.createCity(tLoginAdto.getAreaId());
        boolean masterSlaveOrg = tLoginAdto.isMasterSlaveOrg();
        tLoginAdto.setAddress(address);
        tLoginAdto.setLocation(location);
        tLoginAdto.setLocationCity(locationCity);
        tLoginAdto.setStudentCount(studentCount);
        tLoginAdto.setHasRoles(Collections.<RoleDto> emptyList());
        if (GenericsUtils.notNullAndEmpty(hasRoles)) {
            for (RoleDto rd : hasRoles) {
                TXLoginAccountDto tad = new TXLoginAccountDto();
                tad.setRoleId(rd.getId());
                tad.setOrgLogo(orgLogo);
                tad.setInfoFillStatus(infoFillStatus);
                tad.setInitOrgName(initOrgName);
                tad.setOrgSlogan(orgSlogan);
                tad.setAudit_status(audit_status);
                tad.setShort_name(shortName);
                tad.setNickName(rd.getNotEmptyName());
                tad.setAvatar(avatar);
                tad.setMobile(rd.getMobile());
                tad.setHotline(hotline);
                tad.setHome_page(home_page);
                tad.setDataAccountType(dataAccountType);
                tad.setUser_id(rd.getCascadeId() == null ? user_id : rd.getCascadeId());
                tad.setAuth_token(rd.getAuth_token());
                tad.setType(rd.getType());
                tad.setRoleName(getRoleName(rd.getType()));
                tad.setUser_number(userNumber);
                tad.setAddress(address);
                tad.setLocation(location);
                tad.setLocationCity(city);
                tad.setCreateTime(rd.getCreateTime());
                tad.setStudentCount(studentCount);
                tad.setRoleAvatar(rd.getRoleAvatar());
                tad.setHasPermissions(rd.getHasPermissions());
                tad.setMasterSlaveOrg(masterSlaveOrg);
                retList.add(tad);
            }
        }
        return retList;
    }

    /**
     * @param type
     * @return
     */
    private String getRoleName(Integer type) {
        RoleType roleType = RoleType.getRoleType(type);
        if (roleType != null) {
            if (roleType == RoleType.BRANCH_SCH_PRESIDENT || roleType == RoleType.PRESIDENT) {
                return "校长";
            } else {
                return roleType.desc;
            }
        }
        return "";
    }

    /**
     * @param userNumber
     * @return
     */
    private Map<String, String> getLocationInfos(Integer userNumber) {
        OrgAccount orgAccount = organizationInfoAPIService.findOrgAccountWithOrgNumber(userNumber.longValue());
        if (orgAccount == null) {
            throw new BussinessException(CommonErrorCode.INVALIDATE_CLIENTID, "当前机构不存在");
        }
        Map<String, String> locationInfos = Maps.newHashMap();
        try {
            // 获取机构地址
            List<OrgBranchs> branchsList = orgBranchsDao.listBranchsByOrgId(orgAccount.getId());
            String address = "";
            String location = "";
            String city = "";
            if (GenericsUtils.notNullAndEmpty(branchsList)) {
                OrgBranchs branchs = branchsList.get(0);
                address = buildAddress(branchs.getProvince(), branchs.getCounty(), branchs.getDistrict(),
                    branchs.getAddress(), branchs.getBranchName());
                city = branchs.getProvince();
            }
            String lhost = PropertiesReader.getValue("wxm", "m.server");
            if (lhost != null && lhost.startsWith("https:")) {
                lhost = lhost.replace("https", "http");
            }
            location = lhost + "/branch/" + userNumber;
            locationInfos.put(LOCATION_KEY, location);
            locationInfos.put(ADDRESS_KEY, address);
            locationInfos.put(LOCATION_CITY_KEY, city);
        } catch (Exception e) {
            GenericsUtils.logErrorAndInfo(log, e, " error while getLocationInfos : {} and campusInfoDto is :{} ",
                userNumber);
        }
        return locationInfos;
    }

    private String buildAddress(String...strs) {
        if (GenericsUtils.isNullOrEmpty(strs)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            if (GenericsUtils.notNullAndEmpty(str)) {
                sb.append(str);
            }
        }
        return sb.toString();
    }

    /**
     * @param data
     */
    public void addSpecialLoginLogicForMasterAccount(List<TXLoginAccountDto> data, OrgAccount orgAccount,
        Integer fromOrgId, boolean isFromLogin) {
        if (orgAccount == null) {
            return;
        }
        if (GenericsUtils.isNullOrEmpty(data)) {
            data = Lists.newArrayList();
        }
        Integer fromMasterOrgId = orgAccount.getId();
        log.info("current login user is a master account ,so will add all subAccount master account:{}", orgAccount);
        List<OrgSubAccount> masterAndSlaves = this.orgSubAccountDao.getMasterAndSlaves(fromMasterOrgId, null);
        Set<Integer> orgIds = Sets.newHashSet();
        if (GenericsUtils.notNullAndEmpty(masterAndSlaves)) {
            for (Iterator<OrgSubAccount> iter = masterAndSlaves.iterator(); iter.hasNext();) {
                OrgSubAccount next = iter.next();
                if ((next.getOnlineType() == Flag.TRUE.getInt())
                    || (next.getStatus() != OrgSubAccountStatus.NORMAL.getCode().intValue())
                    || (next.getOrgId().intValue() == fromMasterOrgId.intValue() && isFromLogin)) {
                    iter.remove();
                } else {
                    orgIds.add(next.getOrgId());
                }
            }
            if (GenericsUtils.isNullOrEmpty(orgIds)) {
                return;
            }
            Map<Integer, OrgAccount> findAllOrgAccounts = this.orgAccountDao.listAllOrgAccountByIds(orgIds);
            Map<Integer, TXAccount> findAllTxAccounts = this.txAccountDao.listAllTxAccountByIds(orgIds);
            Map<Integer, OrgInfo> findAllOrgInfos = this.organizationInfoAPIService.getOrgInfoMap(orgIds);
            for (OrgSubAccount osa : masterAndSlaves) {
                Integer orgId_ = osa.getOrgId();
                try {
                    TXLoginAccountDto buildMasterOrSubAccountLoginInfos = this.buildMasterOrSubAccountLoginInfos(
                        findAllOrgAccounts.get(orgId_), findAllTxAccounts.get(orgId_), findAllOrgInfos.get(orgId_),
                        false, osa.getAccountVersion(), fromOrgId, fromMasterOrgId);
                    buildMasterOrSubAccountLoginInfos.setMasterSlaveOrg(true);
                    log.info("buildMasterOrSubAccountLoginInfos is:{} ", buildMasterOrSubAccountLoginInfos);
                    data.add(buildMasterOrSubAccountLoginInfos);
                } catch (Exception e) {
                    log.info("can not find loginInfo for orgSubAccount:{} cause by : {} ", osa, e);
                }
            }
        }
    }

    /**
     * @param fromMasterOrgId
     * @return
     * @throws Exception
     */
    public TXLoginAccountDto buildMasterOrSubAccountLoginInfos(OrgAccount orgAccount, TXAccount txAccount,
        OrgInfo orgInfo, Boolean masterFlag, Integer accountVersion, Integer fromOrgId, Integer fromMasterOrgId)
        throws Exception {
        TXLoginAccountDto dto = buildLoginData(orgAccount, orgInfo);
        log.info(" fromMasterOrgId is :{} ", fromMasterOrgId);
        dto.setDataAccountType(BizConf.NORMAL_ACCOUNT);
        List<RoleDto> roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setId(orgAccount.getNumber());
        roleDto.setNickName(orgInfo.getContacts());
        roleDto.setName("校长");
        roleDto.setMobile(orgAccount.getMobile());
        roleDtos.add(roleDto);
        String auth_token = null;
        if (masterFlag) {
            roleDto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
            // version<2.2.0的版本有个地方支持的auth_token的长度只有126,不是新的登录接口返回的token,会报错
            if (LoginAppInfoContext.isInitPageLoginUsers()) {
                auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, txAccount.getId(), fromOrgId,
                    accountVersion, AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, fromMasterOrgId);
            } else {
                auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, txAccount.getId(), accountVersion,
                    AbstractAuthenticateHandler.TX_APP_ENVIRONMENT);
            }
        } else {
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            if (LoginAppInfoContext.isInitPageLoginUsers()) {
                auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, null, fromOrgId, accountVersion,
                    AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, fromMasterOrgId);
            } else {
                auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), null, null, accountVersion,
                    AbstractAuthenticateHandler.TX_APP_ENVIRONMENT);
            }
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        }
        TxAccountPermissionsDto txAccountPermissionDto =
            txAccountPermissionService.universalGetPermissions(orgAccount.getId(), null);
        roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
        roleDto.setAuth_token(auth_token);
        roleDto.setCreateTime(orgAccount.getCreateTime().getTime());
        // 天校写死的常量
        roleDto.setRoleAvatar(dto.getAvatar());
        InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShowName());
        dto.setHasRoles(roleDtos);
        return dto;
    }

}
