/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www;

import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.LoginAppInfoContext;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTxtMsgService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.beust.jcommander.internal.Maps;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoginAccountDtoHelper {
    private static final Logger log = LoggerFactory.getLogger(LoginAccountDtoHelper.class);
    public static final String NEW_IM_TOKEN = "1";
    public static final String OLD_IM_TOKEN = "2";
    @Autowired
    private OrgTxtMsgService orgTxtMsgService;
    @Autowired
    private OrgPhotoService orgPhotoService;
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;
    @Autowired
    private OrgStudentDao orgStudentDAo;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    private static String ADDRESS_KEY = "address";
    private static String LOCATION_KEY = "location";
    private static String LOCATION_CITY_KEY = "locationCity";

    public TXLoginAccountDto buildLoginData(OrgAccount account, OrgInfo orgInfo) throws Exception {
        log.info("OrgInfo is :{} ", (Object)orgInfo);
        TXLoginAccountDto data = new TXLoginAccountDto();
        data.setShort_name(orgInfo.getShortName());
        data.setUser_id(account.getId());
        data.setUser_number(account.getNumber());
        data.setAudit_status(orgInfo.getAuditStatus());
        data.setHome_page(PropertiesReader.getValue((String)"tianxiao", (String)"TIANXIAO_M") + "i/" + account.getNumber());
        data.setAreaId(orgInfo.getAreaId());
        OrgTxtMsg hotLine = this.orgTxtMsgService.getOrgTxtByIdAndType(account.getId().intValue(), AuditColumType.PHONE.getValue());
        data.setHotline(hotLine == null ? null : hotLine.getValue());
        data.setAvatar(this.orgPhotoService.getPhotoUrlByOrgIdAndCategory(Long.valueOf(account.getId().longValue()), OrgImgType.ORG_LOGO));
        return data;
    }

    public boolean validTXVersion(TXAccount txAccount, String version) {
        if (txAccount.getVipLevel().intValue() != TXAccountType.DAZHONG.getCode().intValue()) {
            return true;
        }
        String vReq = version.replace(".", "");
        String vBase = "153";
        for (int index = 0; index < vBase.length() && Integer.valueOf(String.valueOf(vBase.charAt(0))) >= Integer.valueOf(String.valueOf(vReq.charAt(0))) && Integer.valueOf(String.valueOf(vBase.charAt(1))) >= Integer.valueOf(String.valueOf(vReq.charAt(1))) && Integer.valueOf(String.valueOf(vBase.charAt(1))) >= Integer.valueOf(String.valueOf(vReq.charAt(1))); ++index) {
            Integer base = Integer.valueOf(String.valueOf(vBase.charAt(index)));
            Integer req = Integer.valueOf(String.valueOf(vReq.charAt(index)));
            if (base <= req) continue;
            return false;
        }
        return true;
    }

    public List<TXLoginAccountDto> transformLoginDtos(List<TXLoginAccountDto> loginDtos, String mobile) {
        if (GenericsUtils.isNullOrEmpty(loginDtos)) {
            return GenericsUtils.emptyList();
        }
        ArrayList subOrgIds = Lists.newArrayList();
        TXAccount txAccount = null;
        if (GenericsUtils.notNullAndEmpty((Object)mobile)) {
            txAccount = this.findMasterTXAccount(mobile);
        }
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            if (txAccount != null) {
                InitPageUtils.fillInitPageInfos(txAccount, tLoginAdto, tLoginAdto.getShort_name());
            }
            Integer user_id = tLoginAdto.getUser_id();
            subOrgIds.add(user_id);
        }
        List<TXLoginAccountDto> retNewLoginDtos = this.createAndSortTxLoginDtos(loginDtos, subOrgIds);
        return retNewLoginDtos;
    }

    public List<TXLoginAccountDto> transformLoginDtos(List<TXLoginAccountDto> loginDtos) {
        if (GenericsUtils.isNullOrEmpty(loginDtos)) {
            return GenericsUtils.emptyList();
        }
        ArrayList subOrgIds = Lists.newArrayList();
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            Integer user_id = tLoginAdto.getUser_id();
            subOrgIds.add(user_id);
        }
        List<TXLoginAccountDto> retNewLoginDtos = this.createAndSortTxLoginDtos(loginDtos, subOrgIds);
        return retNewLoginDtos;
    }

    private List<TXLoginAccountDto> createAndSortTxLoginDtos(List<TXLoginAccountDto> loginDtos, List<Integer> subOrgIds) {
        int type;
        HashSet newLoginDtos = Sets.newHashSet();
        Map studentCountMap = this.orgStudentDAo.getStudentCountMapByStatus(subOrgIds, StudentLessonStatus.findSubStatus((int)StudentLessonStatus.STUDYING.getStatus()));
        for (TXLoginAccountDto tXLoginAccountDto : loginDtos) {
            newLoginDtos.addAll(this.createNewTXLoginAccountDto(tXLoginAccountDto, (Integer)studentCountMap.get(tXLoginAccountDto.getUser_id())));
        }
        HashSet isExistsSubRoleSet = Sets.newHashSet();
        for (TXLoginAccountDto tad : newLoginDtos) {
            type = tad.getType();
            if (!tad.isMasterSlaveOrg() || type != RoleType.BRANCH_SCH_PRESIDENT.type) continue;
            log.info("find TXLoginAccountDto :{} is a masterSlaveOrg ", (Object)tad);
            isExistsSubRoleSet.add(tad.getUser_id());
        }
        Iterator iterator = newLoginDtos.iterator();
        while (iterator.hasNext()) {
            TXLoginAccountDto next = (TXLoginAccountDto)iterator.next();
            type = next.getType();
            if (type != RoleType.CHARAGE.type && type != RoleType.EMPLOYEE.type || !isExistsSubRoleSet.contains(next.getUser_id())) continue;
            log.info("find same org has multi roles , so will remove :{} ", (Object)next);
            iterator.remove();
        }
        List<TXLoginAccountDto> list = InitPageUtils.sortResult(newLoginDtos);
        return list;
    }

    public TXAccount findMasterTXAccount(String mobile) {
        OrgAccount accountByMobile = this.orgAccountDao.getAccountByMobile(mobile);
        if (accountByMobile != null) {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(accountByMobile.getId(), new String[0]);
            Integer orgId = accountByMobile.getId();
            if (osa != null) {
                if (osa.getPid() != null && osa.getPid() != 0) {
                    orgId = osa.getPid();
                }
                return this.txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode(), new String[0]);
            }
        }
        return null;
    }

    private List<TXLoginAccountDto> createNewTXLoginAccountDto(TXLoginAccountDto tLoginAdto, Integer studentCount) {
        ArrayList retList = Lists.newArrayList();
        List<RoleDto> hasRoles = tLoginAdto.getHasRoles();
        log.info("hasRoles's size is :{} ", (Object)hasRoles.size());
        String initOrgName = tLoginAdto.getInitOrgName();
        String orgLogo = tLoginAdto.getOrgLogo();
        String orgSlogan = tLoginAdto.getOrgSlogan();
        Integer infoFillStatus = tLoginAdto.getInfoFillStatus();
        Integer audit_status = tLoginAdto.getAudit_status();
        String shortName = tLoginAdto.getShort_name();
        String avatar = tLoginAdto.getAvatar();
        String hotline = tLoginAdto.getHotline();
        Integer user_id = tLoginAdto.getUser_id();
        String home_page = tLoginAdto.getHome_page();
        Integer dataAccountType = tLoginAdto.getDataAccountType();
        Integer userNumber = tLoginAdto.getUser_number();
        Map<String, String> locationInfos = this.getLocationInfos(userNumber);
        String address = locationInfos.get(ADDRESS_KEY);
        String location = locationInfos.get(LOCATION_KEY);
        String locationCity = locationInfos.get(LOCATION_CITY_KEY);
        String city = InitPageUtils.createCity(tLoginAdto.getAreaId());
        boolean masterSlaveOrg = tLoginAdto.isMasterSlaveOrg();
        tLoginAdto.setAddress(address);
        tLoginAdto.setLocation(location);
        tLoginAdto.setLocationCity(locationCity);
        tLoginAdto.setStudentCount(studentCount);
        tLoginAdto.setHasRoles(Collections.emptyList());
        if (GenericsUtils.notNullAndEmpty(hasRoles)) {
            for (RoleDto rd : hasRoles) {
                TXLoginAccountDto tad = new TXLoginAccountDto();
                tad.setRoleId(rd.getId());
                tad.setOrgLogo(orgLogo);
                tad.setInfoFillStatus(infoFillStatus);
                tad.setInitOrgName(initOrgName);
                tad.setOrgSlogan(orgSlogan);
                tad.setAudit_status(audit_status);
                tad.setShort_name(shortName);
                tad.setNickName(rd.getNotEmptyName());
                tad.setAvatar(avatar);
                tad.setMobile(rd.getMobile());
                tad.setHotline(hotline);
                tad.setHome_page(home_page);
                tad.setDataAccountType(dataAccountType);
                tad.setUser_id(rd.getCascadeId() == null ? user_id : rd.getCascadeId());
                tad.setAuth_token(rd.getAuth_token());
                tad.setType(rd.getType());
                tad.setRoleName(this.getRoleName(rd.getType()));
                tad.setUser_number(userNumber);
                tad.setAddress(address);
                tad.setLocation(location);
                tad.setLocationCity(city);
                tad.setCreateTime(rd.getCreateTime());
                tad.setStudentCount(studentCount);
                tad.setRoleAvatar(rd.getRoleAvatar());
                tad.setHasPermissions(rd.getHasPermissions());
                tad.setMasterSlaveOrg(masterSlaveOrg);
                retList.add(tad);
            }
        }
        return retList;
    }

    private String getRoleName(Integer type) {
        RoleType roleType = RoleType.getRoleType((Integer)type);
        if (roleType != null) {
            if (roleType == RoleType.BRANCH_SCH_PRESIDENT || roleType == RoleType.PRESIDENT) {
                return "\u6821\u957f";
            }
            return roleType.desc;
        }
        return "";
    }

    private Map<String, String> getLocationInfos(Integer userNumber) {
        OrgAccount orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgNumber(Long.valueOf(userNumber.longValue()));
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.INVALIDATE_CLIENTID, "\u5f53\u524d\u673a\u6784\u4e0d\u5b58\u5728");
        }
        Map locationInfos = Maps.newHashMap();
        try {
            String lhost;
            List branchsList = this.orgBranchsDao.listBranchsByOrgId(orgAccount.getId().intValue());
            String address = "";
            String location = "";
            String city = "";
            if (GenericsUtils.notNullAndEmpty((Object)branchsList)) {
                OrgBranchs branchs = (OrgBranchs)branchsList.get(0);
                address = this.buildAddress(branchs.getProvince(), branchs.getCounty(), branchs.getDistrict(), branchs.getAddress(), branchs.getBranchName());
                city = branchs.getProvince();
            }
            if ((lhost = PropertiesReader.getValue((String)"wxm", (String)"m.server")) != null && lhost.startsWith("https:")) {
                lhost = lhost.replace("https", "http");
            }
            location = lhost + "/branch/" + userNumber;
            locationInfos.put(LOCATION_KEY, location);
            locationInfos.put(ADDRESS_KEY, address);
            locationInfos.put(LOCATION_CITY_KEY, city);
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)" error while getLocationInfos : {} and campusInfoDto is :{} ", (Object[])new Object[]{userNumber});
        }
        return locationInfos;
    }

    private String buildAddress(String ... strs) {
        if (GenericsUtils.isNullOrEmpty((Object)strs)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            if (!GenericsUtils.notNullAndEmpty((Object)str)) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    public void addSpecialLoginLogicForMasterAccount(List<TXLoginAccountDto> data, OrgAccount orgAccount, Integer fromOrgId, boolean isFromLogin) {
        if (orgAccount == null) {
            return;
        }
        if (GenericsUtils.isNullOrEmpty(data)) {
            data = Lists.newArrayList();
        }
        Integer fromMasterOrgId = orgAccount.getId();
        log.info("current login user is a master account ,so will add all subAccount master account:{}", (Object)orgAccount);
        List masterAndSlaves = this.orgSubAccountDao.getMasterAndSlaves(fromMasterOrgId, null);
        HashSet orgIds = Sets.newHashSet();
        if (GenericsUtils.notNullAndEmpty((Object)masterAndSlaves)) {
            Iterator iter = masterAndSlaves.iterator();
            while (iter.hasNext()) {
                OrgSubAccount next = (OrgSubAccount)iter.next();
                if (next.getOnlineType().intValue() == Flag.TRUE.getInt() || next.getStatus().intValue() != OrgSubAccountStatus.NORMAL.getCode().intValue() || next.getOrgId().intValue() == fromMasterOrgId.intValue() && isFromLogin) {
                    iter.remove();
                    continue;
                }
                orgIds.add(next.getOrgId());
            }
            if (GenericsUtils.isNullOrEmpty((Object)orgIds)) {
                return;
            }
            Map findAllOrgAccounts = this.orgAccountDao.listAllOrgAccountByIds((Collection)orgIds);
            Map findAllTxAccounts = this.txAccountDao.listAllTxAccountByIds((Collection)orgIds);
            Map findAllOrgInfos = this.organizationInfoAPIService.getOrgInfoMap((Collection)orgIds);
            for (OrgSubAccount osa : masterAndSlaves) {
                Integer orgId_ = osa.getOrgId();
                try {
                    TXLoginAccountDto buildMasterOrSubAccountLoginInfos = this.buildMasterOrSubAccountLoginInfos((OrgAccount)findAllOrgAccounts.get(orgId_), (TXAccount)findAllTxAccounts.get(orgId_), (OrgInfo)findAllOrgInfos.get(orgId_), false, osa.getAccountVersion(), fromOrgId, fromMasterOrgId);
                    buildMasterOrSubAccountLoginInfos.setMasterSlaveOrg(true);
                    log.info("buildMasterOrSubAccountLoginInfos is:{} ", (Object)buildMasterOrSubAccountLoginInfos);
                    data.add(buildMasterOrSubAccountLoginInfos);
                }
                catch (Exception e) {
                    log.info("can not find loginInfo for orgSubAccount:{} cause by : {} ", (Object)osa, (Object)e);
                }
            }
        }
    }

    public TXLoginAccountDto buildMasterOrSubAccountLoginInfos(OrgAccount orgAccount, TXAccount txAccount, OrgInfo orgInfo, Boolean masterFlag, Integer accountVersion, Integer fromOrgId, Integer fromMasterOrgId) throws Exception {
        TXLoginAccountDto dto = this.buildLoginData(orgAccount, orgInfo);
        log.info(" fromMasterOrgId is :{} ", (Object)fromMasterOrgId);
        dto.setDataAccountType(0);
        ArrayList roleDtos = Lists.newArrayList();
        RoleDto roleDto = new RoleDto();
        roleDto.setId(orgAccount.getNumber());
        roleDto.setNickName(orgInfo.getContacts());
        roleDto.setName("\u6821\u957f");
        roleDto.setMobile(orgAccount.getMobile());
        roleDtos.add(roleDto);
        String auth_token = null;
        if (masterFlag.booleanValue()) {
            roleDto.setType(CampusAccountType.MASTER_PRINCIPAL.getCode());
            auth_token = LoginAppInfoContext.isInitPageLoginUsers() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), (Integer)fromOrgId, (Integer)accountVersion, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, (Integer)txAccount.getId(), (Integer)accountVersion, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT);
        } else {
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
            auth_token = LoginAppInfoContext.isInitPageLoginUsers() ? EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, null, (Integer)fromOrgId, (Integer)accountVersion, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT, (Integer)fromMasterOrgId) : EncryptUtils.txStrEncode((Integer)orgAccount.getId(), null, null, (Integer)accountVersion, (String)AbstractAuthenticateHandler.TX_APP_ENVIRONMENT);
            roleDto.setType(CampusAccountType.SLAVE_PRINCIPAL.getCode());
        }
        TxAccountPermissionsDto txAccountPermissionDto = this.txAccountPermissionService.universalGetPermissions(orgAccount.getId().intValue(), null);
        roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
        roleDto.setAuth_token(auth_token);
        roleDto.setCreateTime(orgAccount.getCreateTime().getTime());
        roleDto.setRoleAvatar(dto.getAvatar());
        InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShowName());
        dto.setHasRoles(roleDtos);
        return dto;
    }
}

