
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www.authentication.handler;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

import com.baijia.tianxiao.constant.Flag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import com.baijia.tianxiao.biz.www.LoginAccountDtoHelper;
import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.Util.PermissionTransformUtil;
import com.baijia.tianxiao.biz.www.authentication.AbstractAuthenticateHandler;
import com.baijia.tianxiao.biz.www.authentication.Credential;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.biz.www.constant.BizConstant;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeCredential;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.organization.api.OrgAccountService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.TxAccountPermissionsDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgSubAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.util.encrypt.EncryptUtils;
import com.baijia.tianxiao.util.encrypt.PasswordUtil;
import com.baijia.tianxiao.util.memcached.MemcachedUtil;
import com.baijia.yunying.hag.service.HagService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;
import net.rubyeye.xmemcached.exception.MemcachedException;

/**
 * @title TxCascadeAccountAuthenticateHandler
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年8月24日
 * @version 1.0
 */
@Slf4j
public class TxCascadeAccountAuthenticateHandler extends AbstractAuthenticateHandler {
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Autowired
    private LoginAccountDtoHelper loginAccountDtoHelper;
    @Autowired
    private TXAccountService txAccountService;
    @Autowired
    private OrgAccountService orgAccountService;
    @Autowired
    private HagService hagService;
    @Autowired
    private OrgSubAccountService orgSubAccountService;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;

    @Override
    protected boolean doAuthentication(Credential credential, Map<String, Object> options) throws BussinessException {
        // 临时密码
        Boolean isTemp = false;
        try {
            String tempPwd = MemcachedUtil.get("uniq_temp_tx_password_" + credential.getMobile());
            if (StringUtils.isNoneBlank(tempPwd)) {
                if (tempPwd.equals(credential.getPassword())) {
                    MemcachedUtil.delete("uniq_temp_tx_password_" + credential.getMobile());
                    isTemp = true;
                }
            }
        } catch (TimeoutException | InterruptedException | MemcachedException e) {
            log.error("get temp pwd error!mobile:{}", credential.getMobile(), e);
        }

        TXCascadeCredential txCascadeCredential = txCascadeCredentialDao.getByMobile(credential.getMobile());
        if (txCascadeCredential == null) {
            return false;
        }
        
        OrgAccount orgAccount = null;
        if (options.get(ORG_ACCOUNT_KEY) != null) {
            orgAccount = (OrgAccount) options.get(ORG_ACCOUNT_KEY);
        }

        try {
            if (!isTemp) {

                if (orgAccount != null) {
                    if (!PasswordUtil.validatePassword(credential.getPassword(), orgAccount.getPassword())) {
                        log.info("cascade orgAccount pwd error mobile:{}", credential.getMobile());
                        return false;
                    }
                } else {
                    if (!PasswordUtil.validatePassword(credential.getPassword(), txCascadeCredential.getPassword())) {
                        log.info("no orgAccount and cascade credential pwd error mobile:{}", credential.getMobile());
                        return false;
                    }
                }
            }
        } catch (Exception e) {
            log.info("login pwd:{},hash:{},error!:{}", credential.getPassword(), txCascadeCredential.getPassword(), e);
            return false;
        }

        options.put(TX_CASCADE_CREDENTIAL_KEY, txCascadeCredential);
        return true;

    }

    @Override
    protected boolean postAuthenticate(Credential credential, boolean authenticated, List<TXLoginAccountDto> loginDtos,
        Map<String, Object> options) throws BussinessException, Exception {
        TXCascadeCredential txCascadeCredential = (TXCascadeCredential) options.get(TX_CASCADE_CREDENTIAL_KEY);
        OrgAccount masterOrgAccount = (OrgAccount) options.get(ORG_ACCOUNT_KEY);
        Integer fromOrgId = null;
        // 过滤了被禁用 被删除的子帐号
        List<TXCascadeAccount> txCascadeAccounts =
            txCascadeAccountDao.getValidAccountsByCredentialId(txCascadeCredential.getId());
        if (CollectionUtils.isEmpty(txCascadeAccounts)) {
            return false;
        }
        if (masterOrgAccount != null) {
            fromOrgId = masterOrgAccount.getId();
        }
        Map<Integer, TXLoginAccountDto> existDto = Maps.newHashMap();
        log.info("txCascadeAccounts:{}", txCascadeAccounts);
        for (TXCascadeAccount txCascadeAccount : txCascadeAccounts) {
            OrgAccount orgAccount = orgAccountService.getOrgAccountById(txCascadeAccount.getOrgId());
            log.info("for orgAccount :{} , fromOrgId is:{} ", orgAccount, fromOrgId);
            // 总校区
            boolean hasTXPermission = hagService.hasPermission(orgAccount.getNumber(), BizConf.DEFAULT_TYPE,
                BizConf.HAG_RESOURSE_ORG_TIANXIAO_NUMBER);
            if (!hasTXPermission) {
                log.info("no hag txCascadeAccount:{}", txCascadeAccount);
                continue;
            }
            OrgSubAccount orgSubAccount = orgSubAccountService.getByOrgId(orgAccount.getId());
            if (null == orgSubAccount || orgSubAccount.getStatus() != OrgSubAccountStatus.NORMAL.getCode().intValue()){
                log.info("cascade:{}, can not login because the orgSubAccount is forbidden", txCascadeAccount);
                continue;
            }
            // 网校用户不允许登录
            if (null != orgSubAccount && orgSubAccount.getOnlineType() == Flag.TRUE.getInt()){
                log.info("cascade orgSubAccount onlineType invalid:{}", orgSubAccount);
                continue;
            }
            // 这里过滤了被禁用 被删除的天校帐号
            TXAccount txAccount = txAccountService
                .getByOrgId(orgSubAccount.getPid() > 0 ? orgSubAccount.getPid() : orgSubAccount.getOrgId());
            String auth_token = null;
            // 两种情况为null，禁用了，删除了
            if (txAccount == null) {
                    log.info("this cascade:{} can not find txAccount, maybe txAccount is forbidden", txCascadeAccount);
                    continue;
            } else {
                // 大众版用户不让登子帐号, 有子帐号算脏数据
                if (txAccount.getVipLevel() == TXAccountType.DAZHONG.getCode()) {
                    log.info("cascade txAccount invalid111:{}", txAccount);
                    continue;
                }
                // 总校主管允许登录pc,txAccount.id 是登录pc标识
                if (orgSubAccount.getPid() == 0 && txCascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
                    auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), txCascadeAccount.getId(),
                        txAccount.getId(), fromOrgId, txCascadeAccount.getAccountVersion(), TX_APP_ENVIRONMENT);
                } else {
                    auth_token = EncryptUtils.txStrEncode(orgAccount.getId(), txCascadeAccount.getId(), null, fromOrgId,
                        txCascadeAccount.getAccountVersion(), TX_APP_ENVIRONMENT);
                }
            }
            OrgInfo orgInfo = orgInfoService.getOrgInfoByOrgId(orgAccount.getId());

            TXLoginAccountDto dto = null;
            if (existDto.containsKey(orgAccount.getId())) {
                dto = existDto.get(orgAccount.getId());
            } else {
                dto = loginAccountDtoHelper.buildLoginData(orgAccount, orgInfo);
                List<RoleDto> roleDtos = Lists.newArrayList();
                dto.setHasRoles(roleDtos);
                existDto.put(orgAccount.getId(), dto);
                loginDtos.add(dto);
            }
            dto.setDataAccountType(BizConf.NORMAL_ACCOUNT);
            RoleDto roleDto = new RoleDto();
            roleDto.setId(txCascadeAccount.getId());
            roleDto.setNickName(txCascadeCredential.getName());
            roleDto.setType(txCascadeAccount.getAccountType());
            roleDto.setAuth_token(auth_token);
            roleDto.setMobile(txCascadeCredential.getMobile());
            roleDto.setCreateTime(txCascadeAccount.getCreateTime().getTime());

            InitPageUtils.fillInitPageInfos(txAccount, dto, orgInfo.getShowName());

            // 权限
            TxAccountPermissionsDto txAccountPermissionDto =
                txAccountPermissionService.universalGetPermissions(orgAccount.getId(), txCascadeAccount.getId());
            roleDto.setHasPermissions(PermissionTransformUtil.trans(txAccountPermissionDto.getAPPps()));
            if (StringUtils.isNotBlank(txCascadeCredential.getAvatar())) {
                roleDto.setRoleAvatar(txCascadeCredential.getAvatar());
            } else {
                roleDto.setRoleAvatar(BizConstant.DEFAULT_CASCADE_AVATAR);
            }
            dto.getHasRoles().add(roleDto);
        }

        return true;
    }

}
