
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www.authentication.dto;

import java.util.List;

import com.baijia.tianxiao.sal.organization.org.dto.pcAuthority.PermissionDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

/**
 * @title RoleDto
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年8月24日
 * @version 1.0
 */
@Data
public class RoleDto {
    private int id;
    private Integer userId;
    // 角色名称
    private String name;
    // 当前角色手机号
    private String mobile;
    private Integer type;
    // 用户名称
    private String nickName;
    private String auth_token;
    private List<PermissionDto> hasPermissions;
    private String roleAvatar;
    @JsonIgnore
    private Integer cascadeId;
    @JsonIgnore
    private Long createTime;

    public String getNotEmptyName() {
        String retName = this.name;
        return GenericsUtils.isNullOrEmpty(retName) ? this.nickName : retName;
    }

}
