
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www.authentication;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.properties.PropertiesReader;

/**
 * @title AbstractAuthenticateHandler
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年8月24日
 * @version 1.0
 */

public abstract class AbstractAuthenticateHandler {

    protected static final String ORG_ACCOUNT_KEY = "orgAccount";
    protected static final String TX_ACCOUNT_KEY = "txAccount";
    protected static final String TX_VISITOR_KEY = "txVisitor";
    protected static final String TX_CASCADE_CREDENTIAL_KEY = "txCascadeCredential";
    protected static final String MASTER_FLAG = "masterFlag";
    protected static final String TX_ACCOUNT_VERSION = "orgSubAccountVersion";
    protected static final String TX_APP_ENVIRONMENT = PropertiesReader.getValue("rest", "webapp.deploy.environment");

    /**
     * 认证前做一些工作
     * 
     * @param 登录凭证
     * @return 继续认证返回true，否则false
     */
    protected boolean preAuthenticate(Credential credential, Map<String, Object> options) throws BussinessException {
        if (credential == null || StringUtils.isBlank(credential.getMobile())
            || StringUtils.isBlank(credential.getPassword())) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "用户名和密码不能为空");
        }
        return true;
    }

    /**
     * 认证后做一些工作
     * 
     * @param 登录凭证
     * @param 认证结果
     * @return 根据实际情况，是否返回认证成功
     */
    protected boolean postAuthenticate(final Credential credential, final boolean authenticated,
        List<TXLoginAccountDto> loginDtos, Map<String, Object> options) throws BussinessException, Exception {
        return authenticated;
    }

    public final boolean authenticate(final Credential credential, List<TXLoginAccountDto> loginDtos,
        Map<String, Object> options) throws BussinessException, Exception {

        if (!preAuthenticate(credential, options)) {
            return false;
        }

        final boolean authenticated = doAuthentication(credential, options);
        if (authenticated) {
            return postAuthenticate(credential, authenticated, loginDtos, options);
        }
        return false;
    }

    protected abstract boolean doAuthentication(final Credential credential, Map<String, Object> options)
        throws BussinessException;
}
