package com.baijia.tianxiao.biz.www.impl;

import com.baijia.tianxiao.biz.www.TempAccountService;
import com.baijia.tianxiao.dal.course.dao.OrgCourseGroupDao;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.push.dao.MessageDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.TeacherModifiedDao;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/4/26
 * Time: 下午4:51
 * To change this template use File | Settings | File Templates.
 */
@Service
@Slf4j
public class TempAccountServiceImpl implements TempAccountService {

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private MessageDao messageDao;

    @Resource
    private TxConsultUserDao txConsultUserDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgTeacherDao orgTeacherDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgCourseGroupDao orgCourseGroupDao;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private TeacherDao teacherDao;

    @Resource
    private TeacherModifiedDao teacherModifiedDao;

    @Resource
    private OrgRecommendTeacherDao orgRecommendTeacherDao;

    @Resource
    private OrgClassRoomDao orgClassRoomDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Override
    public void refreshTempAccount() {

        OrgAccount orgAccount = orgAccountDao.getAccountById((int) ORG_ACCOUNT_ID);

        messageDao.refreshConsultMessage(orgAccount.getNumber().longValue(), CONSULT_MESSAGE_ID);

        txConsultUserDao.refreshConsultUser(ORG_ACCOUNT_ID, CONSULT_USER_ID);

        orgStudentDao.refreshOrgStudent(ORG_ACCOUNT_ID, ORG_STUDENT_ID);

        orgCourseDao.refreshOrgCourse(orgAccount.getNumber().longValue(), ORG_COURSE_ID);

        orgCourseGroupDao.refreshOrgCourseGroup(ORG_ACCOUNT_ID, ORG_COURSE_GROUP_ID);

        orgClassLessonDao.refreshOrgClassLesson(ORG_ACCOUNT_ID, ORG_CLASS_LESSON_ID);

        teacherDao.refreshCdbTeacher(ORG_ACCOUNT_ID, CDB_TEACHER_ID);

        teacherModifiedDao.refreshCdbTeacherModified(ORG_ACCOUNT_ID, CDB_TEACHER_ID);

        orgTeacherDao.refreshOrgTeacher(ORG_ACCOUNT_ID, ORG_TEACHER_ID);

        orgRecommendTeacherDao.refreshOrgRecommendTeacher(ORG_ACCOUNT_ID, ORG_RECOMMEND_TEACHER_ID);

        orgClassRoomDao.refreshClassRoom(ORG_ACCOUNT_ID, ORG_CLASS_ROOM_ID);

        orgStudentCourseDao.refreshOrgStudentCourse(ORG_ACCOUNT_ID, ORG_STUDENT_COURSE_ID);
    }
}
