package com.baijia.tianxiao.biz.www.constant;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/3/17
 * Time: 上午11:14
 * To change this template use File | Settings | File Templates.
 */
public enum WwwErrorCode implements UniverseErrorCode {

    SESSIONID_ERROR(1001, "session不一致"),
    QRID_EXPIRED(1002, "二维码过期");

    private int code;
    private String message;

    private WwwErrorCode(int code, String msg) {
        this.code = code;
        this.message = msg;
    }

    @Override
    public ErrorSide getErrorSide() {
        return ErrorSide.SERVER;
    }

    @Override
    public Subsystem getSystem() {
        return Subsystem.CONSULT;
    }

    @Override
    public Platform getPlatform() {
        return Platform.PC;
    }

    @Override
    public int getSubsystemErrorCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public UniverseErrorCode fromCode(int code) {
        for (WwwErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return CommonErrorCode.UNKNOW;
    }

}
