
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.www;

import com.baijia.tianxiao.dto.mobile.AppAuthToken;

/**
 * @title QRRedisService
 * @desc 扫码登录相关redis操作 
 * @author caoliang
 * @date 2016年3月15日
 * @version 1.0
 */
public interface QRRedisService {
    
    /**
     * 请求新建二维码时调用，绑定UUID和sessionId对应关系
     * 
     * @param uuid
     * @param sessionId
     */
    public void bindUUIDSid(String uuid, String sessionId);
    
    /**
     * 设置当前二维码登录进度
     * 
     * @param uuid
     * @param status
     */
    public void setUUIDStatus(String uuid, Integer status);
    
    /**
     * 登录成功后，创建共享session
     * redis中key，需要装饰sessionId，和dession保持一致
     * 
     * @param sessionId
     * @param session
     */
    public void initOrgLoginSession(String sessionId, AppAuthToken session);
    
    /**
     * 保存当前帐户登录信息，用于踢出已登录的设备
     * 需要有开关进行逻辑控制
     * 
     * @param obj
     * @param uuid
     */
    public void initOrgLoginInfo(AppAuthToken obj, String uuid);
    
    /**
     * 当前帐户是否已有登录状态
     * 
     * @param obj
     * @return
     */
    public boolean isOrgLogin(AppAuthToken obj);
    
    /**
     * 清除当前帐户登录状态
     * 
     * @param obj
     */
    public void clearOrgLoginInfo(AppAuthToken obj);
    
    /**
     * 当前uuid处理进度
     * 
     * @param uuid
     * @return
     */
    public Integer getUUIDStatus(String uuid);
    
    /**
     * 根据UUID获取绑定的SessionId
     * 
     * @param uuid
     * @return
     */
    public String getSidByUUID(String uuid);
    
    /**
     * App确认登录时，创建临时session对象
     * 
     * @param sessionId
     * @param token
     */
    public void setTempSession(String sessionId, AppAuthToken token);
    
    /**
     * PC确认登录时，取出临时对象，创建真实Session
     * 
     * @param sessionId
     * @return
     */
    public AppAuthToken getTempSession(String sessionId);
    
}

    