
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.www;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTxtMsgService;
import com.baijia.tianxiao.util.properties.PropertiesReader;

import lombok.extern.slf4j.Slf4j;

/**
 * @title LoginAccountDtoHelper
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年8月25日
 * @version 1.0
 */
@Component
@Slf4j
public class LoginAccountDtoHelper {

    // 获取新的IMToken
    public static final String NEW_IM_TOKEN = "1";
    // 获取已有的ImToken
    public static final String OLD_IM_TOKEN = "2";

    @Autowired
    private OrgTxtMsgService orgTxtMsgService;
    @Autowired
    private OrgPhotoService orgPhotoService;

    public TXLoginAccountDto buildLoginData(OrgAccount account, OrgInfo orgInfo) throws Exception {
        TXLoginAccountDto data = new TXLoginAccountDto();
        data.setShort_name(orgInfo.getShortName());
        data.setUser_id(account.getId());
        data.setUser_number(account.getNumber());
        data.setAudit_status(orgInfo.getAuditStatus());
        data.setHome_page(PropertiesReader.getValue("tianxiao", "TIANXIAO_M") + "i/" + account.getNumber());

        // 机构热线
        OrgTxtMsg hotLine = orgTxtMsgService.getOrgTxtByIdAndType(account.getId(), AuditColumType.PHONE.getValue());
        data.setHotline(hotLine == null ? null : hotLine.getValue());
        data.setAvatar(orgPhotoService.getPhotoUrlByOrgIdAndCategory(account.getId().longValue(), OrgImgType.ORG_LOGO));
        return data;
    }

    /**
     * 大众版版本限制
     * 
     * @param requestBody
     * @return
     */
    public boolean validTXVersion(TXAccount txAccount , String version) {
        if(txAccount.getVipLevel().intValue() != TXAccountType.DAZHONG.getCode()){
            return true;
        }
        String vReq = version.replace(".", "");
        String vBase = "153";
        for (int index = 0; index < vBase.length(); index++) {
            if (Integer.valueOf(String.valueOf(vBase.charAt(0))) < Integer.valueOf(String.valueOf(vReq.charAt(0)))) {
                // 首尾版本号已经大于1时，不做判断
                break;
            }
            if (Integer.valueOf(String.valueOf(vBase.charAt(1))) < Integer.valueOf(String.valueOf(vReq.charAt(1)))) {
                // 第二位尾版本号已经大于5时，不做判断
                break;
            }
            if (Integer.valueOf(String.valueOf(vBase.charAt(1))) < Integer.valueOf(String.valueOf(vReq.charAt(1)))) {
                // 第二位版本号已经大于4时，不做判断
                break;
            }
            Integer base = Integer.valueOf(String.valueOf(vBase.charAt(index)));
            Integer req = Integer.valueOf(String.valueOf(vReq.charAt(index)));
            if (base > req) {
                return false;
            }
        }
        return true;
    }
}
