/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.Util;

import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitPageUtils {
    private static final Logger log = LoggerFactory.getLogger(InitPageUtils.class);
    private static GenericsUtils.MulitGroupSortComparator<TXLoginAccountDto> sortByOrgAndCreateTime = new GenericsUtils.MulitGroupSortComparator<TXLoginAccountDto>(){

        public int compare(GenericsUtils.MulitGroupSorter<TXLoginAccountDto> o1_, GenericsUtils.MulitGroupSorter<TXLoginAccountDto> o2_) {
            TXLoginAccountDto o1 = (TXLoginAccountDto)o1_.getObj();
            TXLoginAccountDto o2 = (TXLoginAccountDto)o2_.getObj();
            int compareTo = o1.getCreateTime().compareTo(o2.getCreateTime());
            System.out.println("o1.createTime " + o1.getCreateTime() + " with o2.createTime : " + o2.getCreateTime() + " result : " + compareTo);
            if (compareTo == 0) {
                compareTo = o1.getShort_name().compareTo(o2.getShort_name());
            }
            return compareTo;
        }

        public GenericsUtils.MulitGroupSorter<TXLoginAccountDto> getPid(TXLoginAccountDto obj) {
            return new GenericsUtils.MulitGroupSorter<TXLoginAccountDto>(obj){

                public Object getPid() {
                    return ((TXLoginAccountDto)this.getObj()).getUser_number();
                }
            };
        }
    };
    private static GenericsUtils.GroupSortComparator<Integer, TXLoginAccountDto> sortByType = new GenericsUtils.GroupSortComparator<Integer, TXLoginAccountDto>(){

        public int compare(Integer o1, Integer o2) {
            return o1.compareTo(o2);
        }

        public Integer getPid(TXLoginAccountDto obj) {
            return obj.getType();
        }
    };
    private static List<Comparator> comparatorList = Arrays.asList(sortByOrgAndCreateTime, sortByType);

    public static void fillInitPageInfos(TXAccount txAccount, TXLoginAccountDto dto, String orgName) {
        log.info("txAccount is :{} ", (Object)txAccount);
        String initOrgName = "";
        String orgLogo = "";
        String orgSlogan = "";
        Integer infoFillStatus = 0;
        if (txAccount != null) {
            initOrgName = txAccount.getInitOrgName();
            initOrgName = GenericsUtils.isNullOrEmpty((Object)initOrgName) ? orgName : initOrgName;
            orgSlogan = txAccount.getOrgSlogan();
            orgLogo = txAccount.getOrgLogo();
            Integer infoFillStatus_ = txAccount.getInfoFillStatus();
            if (infoFillStatus_ != 0) {
                infoFillStatus = 1;
            }
        }
        dto.setInfoFillStatus(infoFillStatus);
        dto.setInitOrgName(initOrgName);
        dto.setOrgSlogan(orgSlogan);
        dto.setOrgLogo(orgLogo);
    }

    public static String createCity(Long areaId) {
        Map areaMap = AreaUtils.getAreaNameByCode((Long)areaId);
        log.info("with areaId:{} and areaMap is :{} ", (Object)areaId, (Object)areaMap);
        if (GenericsUtils.notNullAndEmpty((Object)areaMap)) {
            return (String)areaMap.get("city");
        }
        return "";
    }

    public static List<TXLoginAccountDto> sortResult(Collection<TXLoginAccountDto> newLoginDtos) {
        List groupSort = GenericsUtils.groupSort((Collection)Lists.newArrayList(newLoginDtos), (List)Lists.newArrayList(comparatorList));
        return groupSort;
    }

    public static void main(String[] args) {
        ArrayList list = Lists.newArrayList();
        TXLoginAccountDto tlad = new TXLoginAccountDto();
        tlad.setUser_number(331781449);
        tlad.setCreateTime(1486724262000L);
        tlad.setShort_name("\u9e64\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566");
        tlad.setType(1);
        list.add(tlad);
        TXLoginAccountDto tlad2 = new TXLoginAccountDto();
        tlad2.setUser_number(496708249);
        tlad2.setCreateTime(1476772815000L);
        tlad2.setShort_name("\u65b0\u6821\u533a\u8bbe\u7f6e");
        tlad2.setType(3);
        list.add(tlad2);
        TXLoginAccountDto tlad4 = new TXLoginAccountDto();
        tlad4.setUser_number(331781449);
        tlad4.setCreateTime(1486724262000L);
        tlad4.setShort_name("\u9e64\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566\u5566");
        tlad4.setType(4);
        list.add(tlad4);
        TXLoginAccountDto tlad3 = new TXLoginAccountDto();
        tlad3.setUser_number(331778969);
        tlad3.setCreateTime(1486724316000L);
        tlad3.setShort_name("CRM\u673a\u6784");
        tlad3.setType(3);
        list.add(tlad3);
        TXLoginAccountDto tlad5 = new TXLoginAccountDto();
        tlad5.setUser_number(331799449);
        tlad5.setCreateTime(1486724342000L);
        tlad5.setShort_name("\u5317\u4eac\u540c\u5b66\u4f53\u9a8c\u6821\u533a");
        tlad5.setType(4);
        list.add(tlad5);
        List<TXLoginAccountDto> sortResult = InitPageUtils.sortResult(list);
        for (TXLoginAccountDto tlad_ : sortResult) {
            System.out.println("userNumber:" + tlad_.getUser_number() + " -- createTime:" + tlad_.getCreateTime() + " -- shortName:" + tlad_.getShort_name() + " --type:" + tlad_.getType());
        }
    }
}

