/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www;

import com.baijia.tianxiao.biz.www.Util.InitPageUtils;
import com.baijia.tianxiao.biz.www.authentication.dto.RoleDto;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dal.org.constant.AuditColumType;
import com.baijia.tianxiao.dal.org.constant.OrgImgType;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTxtMsg;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.organization.org.service.OrgPhotoService;
import com.baijia.tianxiao.sal.organization.org.service.OrgTxtMsgService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.beust.jcommander.internal.Maps;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoginAccountDtoHelper {
    private static final Logger log = LoggerFactory.getLogger(LoginAccountDtoHelper.class);
    public static final String NEW_IM_TOKEN = "1";
    public static final String OLD_IM_TOKEN = "2";
    @Autowired
    private OrgTxtMsgService orgTxtMsgService;
    @Autowired
    private OrgPhotoService orgPhotoService;
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;
    @Autowired
    private OrgStudentDao orgStudentDAo;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private TXAccountDao txAccountDao;
    private static String ADDRESS_KEY = "address";
    private static String LOCATION_KEY = "location";
    private static String LOCATION_CITY_KEY = "locationCity";

    public TXLoginAccountDto buildLoginData(OrgAccount account, OrgInfo orgInfo) throws Exception {
        log.info("OrgInfo is :{} ", (Object)orgInfo);
        TXLoginAccountDto data = new TXLoginAccountDto();
        data.setShort_name(orgInfo.getShortName());
        data.setUser_id(account.getId());
        data.setUser_number(account.getNumber());
        data.setAudit_status(orgInfo.getAuditStatus());
        data.setHome_page(String.valueOf(PropertiesReader.getValue((String)"tianxiao", (String)"TIANXIAO_M")) + "i/" + account.getNumber());
        data.setAreaId(orgInfo.getAreaId());
        OrgTxtMsg hotLine = this.orgTxtMsgService.getOrgTxtByIdAndType(account.getId().intValue(), AuditColumType.PHONE.getValue());
        data.setHotline(hotLine == null ? null : hotLine.getValue());
        data.setAvatar(this.orgPhotoService.getPhotoUrlByOrgIdAndCategory(Long.valueOf(account.getId().longValue()), OrgImgType.ORG_LOGO));
        return data;
    }

    public boolean validTXVersion(TXAccount txAccount, String version) {
        if (txAccount.getVipLevel().intValue() != TXAccountType.DAZHONG.getCode().intValue()) {
            return true;
        }
        String vReq = version.replace(".", "");
        String vBase = "153";
        int index = 0;
        while (index < vBase.length()) {
            if (Integer.valueOf(String.valueOf(vBase.charAt(0))) < Integer.valueOf(String.valueOf(vReq.charAt(0))) || Integer.valueOf(String.valueOf(vBase.charAt(1))) < Integer.valueOf(String.valueOf(vReq.charAt(1))) || Integer.valueOf(String.valueOf(vBase.charAt(1))) < Integer.valueOf(String.valueOf(vReq.charAt(1)))) break;
            Integer base = Integer.valueOf(String.valueOf(vBase.charAt(index)));
            Integer req = Integer.valueOf(String.valueOf(vReq.charAt(index)));
            if (base > req) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public List<TXLoginAccountDto> transformLoginDtos(List<TXLoginAccountDto> loginDtos, String mobile) {
        if (GenericsUtils.isNullOrEmpty(loginDtos)) {
            return GenericsUtils.emptyList();
        }
        List<Object> newLoginDtos = Lists.newArrayList();
        ArrayList subOrgIds = Lists.newArrayList();
        TXAccount txAccount = null;
        if (GenericsUtils.notNullAndEmpty((Object)mobile)) {
            txAccount = this.findMasterTXAccount(mobile);
        }
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            if (txAccount != null) {
                InitPageUtils.fillInitPageInfos(txAccount, tLoginAdto, tLoginAdto.getShort_name());
            }
            Integer user_id = tLoginAdto.getUser_id();
            subOrgIds.add(user_id);
        }
        Map studentCountMap = this.orgStudentDAo.getStudentCountMapByStatus((List)subOrgIds, StudentLessonStatus.findSubStatus((int)StudentLessonStatus.STUDYING.getStatus()));
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            newLoginDtos.addAll(this.createNewTXLoginAccountDto(tLoginAdto, (Integer)studentCountMap.get(tLoginAdto.getUser_id())));
        }
        newLoginDtos = InitPageUtils.sortResult((Collection<TXLoginAccountDto>)newLoginDtos);
        return newLoginDtos;
    }

    public List<TXLoginAccountDto> transformLoginDtos(List<TXLoginAccountDto> loginDtos) {
        if (GenericsUtils.isNullOrEmpty(loginDtos)) {
            return GenericsUtils.emptyList();
        }
        List<Object> newLoginDtos = Lists.newArrayList();
        ArrayList subOrgIds = Lists.newArrayList();
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            Integer user_id = tLoginAdto.getUser_id();
            subOrgIds.add(user_id);
        }
        Map studentCountMap = this.orgStudentDAo.getStudentCountMapByStatus((List)subOrgIds, StudentLessonStatus.findSubStatus((int)StudentLessonStatus.STUDYING.getStatus()));
        for (TXLoginAccountDto tLoginAdto : loginDtos) {
            newLoginDtos.addAll(this.createNewTXLoginAccountDto(tLoginAdto, (Integer)studentCountMap.get(tLoginAdto.getUser_id())));
        }
        newLoginDtos = InitPageUtils.sortResult((Collection<TXLoginAccountDto>)newLoginDtos);
        return newLoginDtos;
    }

    public TXAccount findMasterTXAccount(String mobile) {
        OrgAccount accountByMobile = this.orgAccountDao.getAccountByMobile(mobile);
        if (accountByMobile != null) {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(accountByMobile.getId(), new String[0]);
            Integer orgId = accountByMobile.getId();
            if (osa != null) {
                if (osa.getPid() != null && osa.getPid() != 0) {
                    orgId = osa.getPid();
                }
                return this.txAccountDao.getByOrgId(orgId, TXAccountStatus.VALID.getCode(), new String[0]);
            }
        }
        return null;
    }

    private List<TXLoginAccountDto> createNewTXLoginAccountDto(TXLoginAccountDto tLoginAdto, Integer studentCount) {
        ArrayList retList = Lists.newArrayList();
        List<RoleDto> hasRoles = tLoginAdto.getHasRoles();
        log.info("hasRoles's size is :{} ", (Object)hasRoles.size());
        String initOrgName = tLoginAdto.getInitOrgName();
        String orgLogo = tLoginAdto.getOrgLogo();
        String orgSlogan = tLoginAdto.getOrgSlogan();
        Integer infoFillStatus = tLoginAdto.getInfoFillStatus();
        Integer audit_status = tLoginAdto.getAudit_status();
        String shortName = tLoginAdto.getShort_name();
        String avatar = tLoginAdto.getAvatar();
        String hotline = tLoginAdto.getHotline();
        Integer user_id = tLoginAdto.getUser_id();
        String home_page = tLoginAdto.getHome_page();
        Integer dataAccountType = tLoginAdto.getDataAccountType();
        Integer userNumber = tLoginAdto.getUser_number();
        Map<String, String> locationInfos = this.getLocationInfos(userNumber);
        String address = locationInfos.get(ADDRESS_KEY);
        String location = locationInfos.get(LOCATION_KEY);
        String locationCity = locationInfos.get(LOCATION_CITY_KEY);
        String city = InitPageUtils.createCity(tLoginAdto.getAreaId());
        tLoginAdto.setAddress(address);
        tLoginAdto.setLocation(location);
        tLoginAdto.setLocationCity(locationCity);
        tLoginAdto.setStudentCount(studentCount);
        tLoginAdto.setHasRoles(Collections.emptyList());
        if (GenericsUtils.notNullAndEmpty(hasRoles)) {
            for (RoleDto rd : hasRoles) {
                TXLoginAccountDto tad = new TXLoginAccountDto();
                tad.setRoleId(rd.getId());
                tad.setOrgLogo(orgLogo);
                tad.setInfoFillStatus(infoFillStatus);
                tad.setInitOrgName(initOrgName);
                tad.setOrgSlogan(orgSlogan);
                tad.setAudit_status(audit_status);
                tad.setShort_name(shortName);
                tad.setNickName(rd.getNotEmptyName());
                tad.setAvatar(avatar);
                tad.setMobile(rd.getMobile());
                tad.setHotline(hotline);
                tad.setHome_page(home_page);
                tad.setDataAccountType(dataAccountType);
                tad.setUser_id(rd.getCascadeId() == null ? user_id : rd.getCascadeId());
                tad.setAuth_token(rd.getAuth_token());
                tad.setType(rd.getType());
                tad.setRoleName(this.getRoleName(rd.getType()));
                tad.setUser_number(userNumber);
                tad.setAddress(address);
                tad.setLocation(location);
                tad.setLocationCity(city);
                tad.setCreateTime(rd.getCreateTime());
                tad.setStudentCount(studentCount);
                tad.setRoleAvatar(rd.getRoleAvatar());
                tad.setHasPermissions(rd.getHasPermissions());
                retList.add(tad);
            }
        }
        return retList;
    }

    private String getRoleName(Integer type) {
        RoleType roleType = RoleType.getRoleType((Integer)type);
        if (roleType != null) {
            if (roleType == RoleType.BRANCH_SCH_PRESIDENT || roleType == RoleType.PRESIDENT) {
                return "\u6821\u957f";
            }
            return roleType.desc;
        }
        return "";
    }

    private Map<String, String> getLocationInfos(Integer userNumber) {
        OrgAccount orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgNumber(Long.valueOf(userNumber.longValue()));
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.INVALIDATE_CLIENTID, "\u5f53\u524d\u673a\u6784\u4e0d\u5b58\u5728");
        }
        Map locationInfos = Maps.newHashMap();
        try {
            String lhost;
            List branchsList = this.orgBranchsDao.listBranchsByOrgId(orgAccount.getId().intValue());
            String address = "";
            String location = "";
            String city = "";
            if (GenericsUtils.notNullAndEmpty((Object)branchsList)) {
                OrgBranchs branchs = (OrgBranchs)branchsList.get(0);
                address = this.buildAddress(branchs.getProvince(), branchs.getCounty(), branchs.getDistrict(), branchs.getAddress(), branchs.getBranchName());
                city = branchs.getProvince();
            }
            if ((lhost = PropertiesReader.getValue((String)"wxm", (String)"m.server")) != null && lhost.startsWith("https:")) {
                lhost = lhost.replace("https", "http");
            }
            location = String.valueOf(lhost) + "/branch/" + userNumber;
            locationInfos.put(LOCATION_KEY, location);
            locationInfos.put(ADDRESS_KEY, address);
            locationInfos.put(LOCATION_CITY_KEY, city);
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)" error while getLocationInfos : {} and campusInfoDto is :{} ", (Object[])new Object[]{userNumber});
        }
        return locationInfos;
    }

    private String buildAddress(String ... strs) {
        if (GenericsUtils.isNullOrEmpty((Object)strs)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (GenericsUtils.notNullAndEmpty((Object)str)) {
                sb.append(str);
            }
            ++n2;
        }
        return sb.toString();
    }
}

