/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.www.impl;

import com.baijia.commons.dession.serialize.JavaObjectSerializer;
import com.baijia.commons.lang.utils.JacksonUtil;
import com.baijia.tianxiao.biz.www.QRRedisService;
import com.baijia.tianxiao.biz.www.constant.QrLoginStatus;
import com.baijia.tianxiao.dto.mobile.AppAuthToken;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class QRRedisServiceImpl
implements QRRedisService {
    private static final Logger log = LoggerFactory.getLogger(QRRedisServiceImpl.class);
    private static final String QR_LOGIN_PREFIX = "tx_qr_login_";
    private static final String QR_LOGIN_STATUS_PREFIX = "tx_qr_login_status_";
    private static final String QR_LOGIN_SID_PREFIX = "tx_qr_login_sessionid_";
    private static final String QR_LOGIN_TEMP_SESSION_PREFIX = "tx_qr_temp_session_";
    private static final String QR_LOGIN_APP_VERSION_PREFIX = "tx_qr_app_version_";
    private static final String QR_LOGIN_SEP = "_";
    private static final String QR_LOGIN_UUID_SEP = ",";
    @Autowired
    private StringRedisTemplate redisTemplate;

    public StringRedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(StringRedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void bindUUIDSid(String uuid, final String sessionId) {
        final String key = this.generateUUIDSIDKey(uuid);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(key.getBytes(), 300L, sessionId.getBytes());
                return null;
            }
        });
    }

    @Override
    public void setUUIDStatus(String uuid, final Integer status) {
        final String key = this.generateUUIDSTATUSKey(uuid);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(key.getBytes(), 300L, status.toString().getBytes());
                return null;
            }
        });
    }

    @Override
    public void initOrgLoginSession(final String sessionId, final AppAuthToken session) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                try {
                    JavaObjectSerializer serializer = new JavaObjectSerializer();
                    connection.hSet(sessionId.getBytes(), "LOGIN_SESSION".getBytes(), serializer.serialize((Object)session));
                }
                catch (Exception e) {
                    log.error("initOrgLoginSession error!sessionId:{},session:{}", new Object[]{sessionId, session, e});
                }
                return null;
            }
        });
    }

    @Override
    public void initOrgLoginInfo(AppAuthToken obj, final String uuid) {
        final String key = this.generateOrgLoginKey(obj);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                String olduuids = (String)QRRedisServiceImpl.this.redisTemplate.getStringSerializer().deserialize(connection.get(key.getBytes()));
                String newuuids = null;
                newuuids = StringUtils.isNotEmpty((CharSequence)olduuids) ? Joiner.on((String)QRRedisServiceImpl.QR_LOGIN_UUID_SEP).join((Object)olduuids, (Object)uuid, new Object[0]) : uuid;
                connection.setEx(key.getBytes(), 86400L, newuuids.getBytes());
                String uuidSidKey = QRRedisServiceImpl.this.generateUUIDSIDKey(uuid);
                byte[] sidValue = connection.get(uuidSidKey.getBytes());
                if (sidValue == null || sidValue.length == 0) {
                    return null;
                }
                connection.expire(uuidSidKey.getBytes(), 86400L);
                return null;
            }
        });
    }

    @Override
    public boolean isOrgLogin(AppAuthToken obj) {
        final String key = this.generateOrgLoginKey(obj);
        boolean isExist = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.exists(key.getBytes());
            }
        });
        return isExist;
    }

    @Override
    public void clearOrgLoginInfo(AppAuthToken obj) {
        final String key = this.generateOrgLoginKey(obj);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                List uuids;
                String uuidsStr = (String)QRRedisServiceImpl.this.redisTemplate.getStringSerializer().deserialize(connection.get(key.getBytes()));
                if (StringUtils.isNotEmpty((CharSequence)uuidsStr) && CollectionUtils.isNotEmpty((Collection)(uuids = Splitter.on((String)QRRedisServiceImpl.QR_LOGIN_UUID_SEP).splitToList((CharSequence)uuidsStr)))) {
                    for (String uuid : uuids) {
                        String uuidSidKey = QRRedisServiceImpl.this.generateUUIDSIDKey(uuid);
                        String sessionId = (String)QRRedisServiceImpl.this.redisTemplate.getStringSerializer().deserialize(connection.get(uuidSidKey.getBytes()));
                        String uuidStatusKey = QRRedisServiceImpl.this.generateUUIDSTATUSKey(uuid);
                        connection.del((byte[][])new byte[][]{key.getBytes()});
                        connection.del((byte[][])new byte[][]{uuidSidKey.getBytes()});
                        connection.del((byte[][])new byte[][]{uuidStatusKey.getBytes()});
                        if (!StringUtils.isNotEmpty((CharSequence)sessionId)) continue;
                        connection.del((byte[][])new byte[][]{sessionId.getBytes()});
                    }
                }
                return null;
            }
        });
    }

    private String generateUUIDSIDKey(String uuid) {
        StringBuilder key = new StringBuilder();
        key.append(QR_LOGIN_SID_PREFIX);
        key.append(uuid);
        return key.toString();
    }

    private String generateUUIDSTATUSKey(String uuid) {
        StringBuilder key = new StringBuilder();
        key.append(QR_LOGIN_STATUS_PREFIX);
        key.append(uuid);
        return key.toString();
    }

    private String generateOrgLoginKey(AppAuthToken token) {
        StringBuilder key = new StringBuilder();
        key.append(QR_LOGIN_PREFIX);
        key.append(token.getUser_id());
        key.append(QR_LOGIN_SEP);
        key.append(token.getTx_cascade_user_id());
        key.append(QR_LOGIN_SEP);
        key.append(token.getCt());
        key.append(QR_LOGIN_SEP);
        key.append(token.getSalt());
        return key.toString();
    }

    private String generateTempSessionKey(String sessionId) {
        StringBuilder key = new StringBuilder();
        key.append(QR_LOGIN_TEMP_SESSION_PREFIX);
        key.append(sessionId);
        return key.toString();
    }

    @Override
    public Integer getUUIDStatus(String uuid) {
        final String key = this.generateUUIDSTATUSKey(uuid);
        Integer status = (Integer)this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] value = connection.get(key.getBytes());
                if (value == null || value.length == 0) {
                    return QrLoginStatus.EXPIRED.getCode();
                }
                String status = (String)QRRedisServiceImpl.this.redisTemplate.getStringSerializer().deserialize(value);
                return Integer.valueOf(status);
            }
        });
        return status;
    }

    @Override
    public String getSidByUUID(String uuid) {
        final String key = this.generateUUIDSIDKey(uuid);
        String sessionId = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] value = connection.get(key.getBytes());
                if (value == null || value.length == 0) {
                    return null;
                }
                String sessionId = (String)QRRedisServiceImpl.this.redisTemplate.getStringSerializer().deserialize(value);
                return sessionId;
            }
        });
        return sessionId;
    }

    @Override
    public void setTempSession(final String sessionId, final AppAuthToken token) {
        final String key = this.generateTempSessionKey(sessionId);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                try {
                    String tokenStr = JacksonUtil.obj2Str((Object)token);
                    log.info("key:{},value;{}", (Object)key, (Object)tokenStr);
                    connection.setEx(key.getBytes(), 300L, tokenStr.getBytes());
                    log.info("tempSession:{}", QRRedisServiceImpl.this.redisTemplate.getStringSerializer().deserialize(connection.get(key.getBytes())));
                }
                catch (IOException e) {
                    log.error("setTempSession error!sessionId:{},token:{}", new Object[]{sessionId, token, e});
                }
                return null;
            }
        });
    }

    @Override
    public AppAuthToken getTempSession(final String sessionId) {
        final String key = this.generateTempSessionKey(sessionId);
        AppAuthToken token = (AppAuthToken)this.redisTemplate.execute((RedisCallback)new RedisCallback<AppAuthToken>(){

            public AppAuthToken doInRedis(RedisConnection connection) throws DataAccessException {
                AppAuthToken token = null;
                try {
                    String tokenStr = (String)QRRedisServiceImpl.this.redisTemplate.getStringSerializer().deserialize(connection.get(key.getBytes()));
                    token = (AppAuthToken)JacksonUtil.str2Obj((String)tokenStr, AppAuthToken.class);
                    connection.del((byte[][])new byte[][]{key.getBytes()});
                }
                catch (IOException e) {
                    log.error("getTempSession error!sessionId:{}", (Object)sessionId, (Object)e);
                }
                return token;
            }
        });
        return token;
    }

    @Override
    public void setAppVersion(String sessionId, final String version) {
        final String key = this.generateAppVersionKey(sessionId);
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                try {
                    log.info("versionkey:{},version;{}", (Object)key, (Object)version);
                    connection.setEx(key.getBytes(), 300L, version.getBytes());
                }
                catch (Exception e) {
                    log.error("setTempSession error!sessionId:{},appversion:{}", new Object[]{key, version, e});
                }
                return null;
            }
        });
    }

    private String generateAppVersionKey(String sessionId) {
        StringBuilder key = new StringBuilder();
        key.append(QR_LOGIN_APP_VERSION_PREFIX);
        key.append(sessionId);
        return key.toString();
    }

    @Override
    public String getAppVersion(final String sessionId) {
        final String key = this.generateAppVersionKey(sessionId);
        String version = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                String version = null;
                try {
                    version = (String)QRRedisServiceImpl.this.redisTemplate.getStringSerializer().deserialize(connection.get(key.getBytes()));
                    connection.del((byte[][])new byte[][]{key.getBytes()});
                }
                catch (Exception e) {
                    log.error("getAppVersion error!sessionId:{}", (Object)sessionId, (Object)e);
                }
                return version;
            }
        });
        return version;
    }
}

