
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.www.authentication;

import com.baijia.tianxiao.biz.www.IllegalAccessCtrlService;
import com.baijia.tianxiao.biz.www.authentication.dto.TXLoginAccountDto;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

/**
 * @title AuthenticateManagerImpl
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年8月24日
 * @version 1.0
 */
@Data
@Slf4j
public class AuthenticateManagerImpl implements AuthenticateManager {

    @Getter
    private static final String LOGIN_KEY_PREFIX = "tx_login_code_";
    private List<AbstractAuthenticateHandler> handlers;

    @Autowired
    private IllegalAccessCtrlService accessCtrService;
    
    @Override
    public List<TXLoginAccountDto> authenticate(Credential credential, Map<String, Object> options) throws BussinessException, Exception {
        List<TXLoginAccountDto> loginDtos = Lists.newArrayList();
        log.info("login credential:{}",credential);
        String redisKey = LOGIN_KEY_PREFIX + credential.getMobile();
        if(accessCtrService.isLocked(redisKey)){
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR,"账户已被锁定，请1小时候再试");
        }
        boolean succAuthenticate= false;
        log.info("handlers:{}",handlers);
        for(AbstractAuthenticateHandler handler : handlers){
            if(handler.authenticate(credential, loginDtos, options)){
                succAuthenticate = true;
            }
        }
        if(!succAuthenticate){
            log.debug("login fail");
            WebResponse<Object> detectRes = accessCtrService.detect(redisKey);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR,detectRes.getMsg());
        }
        
        log.info("login loginDtos:{}",loginDtos);
        return loginDtos;
    }
}

    