/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.wechat.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.util.CookieUtil;

import lombok.Data;

/**   
 * @title       : WechatWebAuthCookieDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2017年3月21日 上午11:53:42 
 */
@Data	
public class WechatWebAuthCookieUtil {
	
	//TODO 
	//目前以wechatAppId为key (暂未加密 需要对key加密)
	//或者不已 wechatAppId 以字符串openId为key 
	
	
	public static void addCookieOpenId(String wechatAppId, String openId, HttpServletResponse response){
		//获取一级域名
        Pattern pattern = Pattern.compile("://([^/]*)/");
    	Matcher matcher = pattern.matcher( WechatProperties.getWebAuthUrlPrefix() );
    	matcher.find();
    	String domain = matcher.group(1);
    	
		String[] domainSplit = domain.split("\\.");
		domain = String.format("%s.%s", domainSplit[domainSplit.length-2], domainSplit[domainSplit.length-1]);
		
		CookieUtil.addCookie(response, wechatAppId, openId, domain, "/", 15*60);//有效期15分钟
	}
	
	
	public static Cookie getCookieOpenId(String wechatAppId, HttpServletRequest request){
		return CookieUtil.getCookie(request, wechatAppId);
	}

}

