/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.wechat.service.impl;

import com.baijia.tianxiao.biz.wechat.dto.WechatCallbackResponseDto;
import com.baijia.tianxiao.biz.wechat.service.WechatWebAuthService;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.smstoken.WechatSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.RedirectException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import com.baijia.tianxiao.sal.wechat.api.WebAuthService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.fans.FansDetailDto;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthDto;
import com.baijia.tianxiao.util.SerializeUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class WechatWebAuthServiceImpl
implements WechatWebAuthService {
    private static final Logger log = LoggerFactory.getLogger(WechatWebAuthServiceImpl.class);
    @Autowired
    private WebAuthService webAuthService;
    @Autowired
    private FansService fansService;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    String getWechatCallbackResponseKey(WebAuthDto webAuthDto) {
        return "tx_webauth_" + webAuthDto.getCode();
    }

    private void cacheWechatCallbackResponse(final WebAuthDto webAuthDto, final WechatCallbackResponseDto responseDto) {
        try {
            this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

                public Object doInRedis(RedisConnection connection) throws DataAccessException {
                    String key = WechatWebAuthServiceImpl.this.getWechatCallbackResponseKey(webAuthDto);
                    connection.set(key.getBytes(), SerializeUtil.serialize((Object)((Object)responseDto)));
                    connection.expire(key.getBytes(), 1800L);
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error("cacheWechatCallbackResponse - exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5fae\u4fe1\u7f51\u9875\u6388\u6743\u7f13\u5b58\u5931\u8d25");
        }
    }

    private WechatCallbackResponseDto getWechatCallbackResponse(final WebAuthDto webAuthDto) {
        try {
            return (WechatCallbackResponseDto)((Object)this.redisTemplate.execute((RedisCallback)new RedisCallback<WechatCallbackResponseDto>(){

                public WechatCallbackResponseDto doInRedis(RedisConnection connection) throws DataAccessException {
                    String key = WechatWebAuthServiceImpl.this.getWechatCallbackResponseKey(webAuthDto);
                    if (connection.exists(key.getBytes()).booleanValue()) {
                        byte[] value = connection.get(key.getBytes());
                        Object obj = SerializeUtil.unserialize((byte[])value);
                        if (obj != null) {
                            return (WechatCallbackResponseDto)((Object)obj);
                        }
                        return null;
                    }
                    return null;
                }
            }));
        }
        catch (Exception e) {
            log.error("getWechatCallbackResponse - exception:", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2 \u5fae\u4fe1\u7f51\u9875\u6388\u6743\u7f13\u5b58\u5931\u8d25");
        }
    }

    @Override
    public WechatCallbackResponseDto getInfoByWebAuthorization(WebAuthDto webAuthDto, String webAuthLink4UserInfo) throws RedirectException, BussinessException {
        Object dto;
        String openId;
        AuthorizationInfo authorizationInfo;
        block14: {
            WechatCallbackResponseDto cacheDto = this.getWechatCallbackResponse(webAuthDto);
            if (cacheDto != null) {
                return cacheDto;
            }
            authorizationInfo = this.authorizationInfoService.getByAuthorizerAppId(webAuthDto.getAppid());
            if (authorizationInfo == null) {
                throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_UNBIND_ORG);
            }
            openId = null;
            try {
                if (webAuthDto.getScope().equals(WebAuthScope.BASE.getValue())) {
                    dto = this.webAuthService.getWebAuthorizationDtoByWebAuthCode(webAuthDto);
                    FansDetailDto fansDto = this.fansService.getFansDetail(dto.getOpenid());
                    if (fansDto == null) {
                        throw new RedirectException("\u4e0d\u5b58\u5728\u7528\u6237\u4fe1\u606f 302\u8df3\u8f6c\u7533\u8bf7\u7528\u6237\u4fe1\u606f\u6388\u6743", webAuthLink4UserInfo);
                    }
                    openId = fansDto.getOpenId();
                    break block14;
                }
                if (webAuthDto.getScope().equals(WebAuthScope.USERINFO.getValue())) {
                    Fans fans = this.webAuthService.getWechatUserByWebAuthCode(webAuthDto);
                    if (fans != null) {
                        openId = fans.getOpenId();
                        fans.setAuthorizerAppId(webAuthDto.getAppid());
                        Fans fansInDB = this.fansService.getFans(openId);
                        if (fansInDB != null) {
                            fans.setLastCommunicationTime(fansInDB.getLastCommunicationTime());
                        }
                        this.fansService.saveOrUpdateFans(fans);
                    }
                    break block14;
                }
                throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_WEB_AUTH_FAIL, "\u975e\u6cd5\u7684scope:" + webAuthDto.getScope());
            }
            catch (RedirectException e) {
                throw e;
            }
            catch (Exception e) {
                log.warn("wechat - webauth - getInfoByWebAuthorization - exception ", (Throwable)e);
                throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_WEB_AUTH_FAIL);
            }
        }
        dto = new WechatCallbackResponseDto(Long.parseLong(authorizationInfo.getOrgId() + ""), openId, webAuthDto.getAppid());
        if (StringUtils.isNotBlank((CharSequence)webAuthDto.getSms_token())) {
            WechatSmsTokenDto token = null;
            try {
                token = WechatSmsTokenDto.fromTokenStr((String)webAuthDto.getSms_token());
                ((WechatCallbackResponseDto)((Object)dto)).setOrgId(token.getOrgId());
                if (!authorizationInfo.getAuthorizerAppId().equals(token.getWechatAppId()) || !this.freeVersionService.isFreeAccount(authorizationInfo.getAuthorizerAppId())) {
                    throw new RuntimeException(" wrong smstoken ");
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        this.cacheWechatCallbackResponse(webAuthDto, (WechatCallbackResponseDto)((Object)dto));
        return dto;
    }
}

