
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2017 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.tasks;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;

import com.baijia.tianxiao.biz.tasks.queryParam.CreateTeacherRequest;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.sal.common.api.OrgTeacherForSolrService;
import com.baijia.tianxiao.task.local.annotation.TaskBean;
import com.baijia.tianxiao.task.local.annotation.TaskService;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.base.Function;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Feb 20, 2017
 * @Desc this guy is too lazy, nothing left.
 */
@Data
@Slf4j
@TaskService
public class TeacherInfoDocumentTaskService {

    public static final Integer PAGE_SIZE = 100;

    @Autowired
    private OrgTeacherDao orgTeacherDao;
    @Autowired
    private TeacherDao teacherDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private OrgTeacherForSolrService orgTeacherForSolrService;

    @TaskBean(value = "createTeacherInfoDocumentTask")
    public void doTask(CreateTeacherRequest request) {
        Date beginDate = DateUtil.getStartOfMonth();
        Date endDate = DateUtil.getEndOfMonth();
        log.info("with orgIds :{} and startDate:{} ,endDate:{} ,the task is create over!", request.getOrgIds(),
            beginDate, endDate);
        if (GenericsUtils.notNullAndEmpty(request.getOrgIds())) {
            for (Long orgId : request.getOrgIds()) {
                createTeacherInfoDocuemnts(orgId, beginDate, endDate);
            }
        } else {
            log.info("current task can not find any orgId to create teacher's document!");
        }
    }

    private void createTeacherInfoDocuemnts(Long orgId, Date beginDate, Date endDate) {
        try {
            Long lastId = null;
            List<OrgTeacher> orgTeachers = orgTeacherDao.listByLastId(orgId, lastId, PAGE_SIZE, null, null);
            log.info("orgTeachers'size is :{} ", orgTeachers.size());
            while (GenericsUtils.notNullAndEmpty(orgTeachers)) {
                Map<Long, OrgTeacher> orgTeacherMap =
                    CollectorUtil.collectMap(orgTeachers, new Function<OrgTeacher, Long>() {
                        @Override
                        public Long apply(OrgTeacher teacher) {
                            return teacher.getUserId();
                        }
                    });
                log.info("--------0---------");
                orgTeacherForSolrService.createOrgTeacherDocuments(orgId, orgTeacherMap.values(), beginDate, endDate,
                    true);
                log.info("--------1---------");
                lastId = orgTeachers.get(orgTeachers.size() - 1).getId();
                orgTeachers = orgTeacherDao.listByLastId(orgId, lastId, PAGE_SIZE, null, null);
            }
        } catch (Exception e) {
            log.error("error :{} ", e);
        }
        log.info("[CreateTeacherInfoDocumentTask] current task for orgId :{} is over ", orgId);
    }

}
