package com.baijia.tianxiao.biz.student.syn.service;

import com.baijia.tianxiao.dal.org.po.OrgLessonSign;

import java.util.Date;
import java.util.List;

/**
 * Created by liuxp on 16/7/22.
 */
public interface StudentKexiaoService {

    /**
     * 刷新课消规则
     */
    public void refreshKexiaoRule(int beforeMinutes);

    /**
     * 根据签到记录跟新课消状态
     * @param lessonSigns
     */
    public void updateClassLessonStatusBySignUp(List<OrgLessonSign> lessonSigns);

    /**
     * 根据学生课节时间的变化同步课消状态
     */
    public void updateStudentLesson();

    /**
     * 修订数据
     * @param beforeMinute
     */
    public void updateStudentLessonByTime(int beforeMinute);
    
    /**
     * 修订课消状态,主要是Databus问题导致数据不对的情况
     */
    public void reviseKexiaoStatus(Date startTime, Date endTime);

}
