/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.student.customStudentField.service.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

import com.baijia.tianxiao.biz.student.dto.response.SimpleFieldDto;
import com.baijia.tianxiao.dal.finance.dao.TxStudentFinanceAccountDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStudentStat;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.sal.organization.org.service.*;
import com.baijia.tianxiao.sal.student.enums.SystemFields;
import com.baijia.tianxiao.sal.wechat.util.EmojiUtil;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.yunying.hag.common.web.ErrorCode;
import org.apache.solr.common.SolrException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.student.customStudentField.service.BizCustomFieldService;
import com.baijia.tianxiao.biz.student.dto.DefaultSetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.SetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentInfo;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentResponse;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.constant.ChargeType;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.organization.constant.CascadeSearchSource;
import com.baijia.tianxiao.sal.organization.org.dto.AccountSelectionDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialSelectionDto;
import com.baijia.tianxiao.sal.signup.dto.request.StudentBalanceRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.StudentBalanceResponseDto;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueRequest;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.RequireStatus;
import com.baijia.tianxiao.sal.student.enums.SpecialFieldEnum;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年7月28日
 * @desc
 */
@Service
@Slf4j
public class BizCustomFieldServiceImpl implements BizCustomFieldService {
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TxCascadeCredentialService orgTxCascadeCredentialService;
    @Autowired
    private ConsultSourceService consultSourceService;
    @Autowired
    private TXSaleClueRuleService saleClueRuleService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCommonRuleService txCommonRuleService;
    @Autowired
    private UnifiedWechatAccountService unifiedWechatAccountService;
    @Autowired
    private StudentUserService studentUserService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private TxStudentFinanceAccountService txStudentFinanceAccountService;
    @Autowired
    private StudentKexiaoStatisticsApiService studentKexiaoStatisticsApiService;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private TxStudentFinanceAccountDao studentFinanceAccountDao;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private TXCustomOptionDao optionDao;

    public static String TIP_STR = "学员部分班级需补充信息后才可核算课消";
    public static String TIP_INFO_URL = "http://bbs.tianxiao100.com/forum.php?mod=viewthread&tid=95";

    @Override
    public Object listCustomFields(Long orgId, Integer customType) {
        return null;
    }

    /**
     * 获取学员的详情,课消2.0新接口
     *
     * @param studentId
     * @param cascadeId
     * @param orgId
     * @param applicationType
     * @return
     */
    @Override
    public OrgStudentResponse getOrgStudentInfoForKeXiao(Long studentId, Integer cascadeId, Long orgId,
                                                         Integer applicationType) {
        OrgStudentResponse orgStudentInfoForKeXiao =
                this.getOrgStudentInfoForKeXiao(studentId, cascadeId, orgId, applicationType, false);
        fillStatistics(studentId, orgId, orgStudentInfoForKeXiao);
        return orgStudentInfoForKeXiao;
    }

    @Override
    @Transactional
    public OrgStudentResponse getOrgStudentInfo(Long studentId, Integer cascadeId, Long orgId,
                                                Integer applicationType) {
        OrgStudentResponse orgStudentInfoForKeXiao =
                this.getOrgStudentInfoForKeXiao(studentId, cascadeId, orgId, applicationType, true);
        if (studentId != -1) {
            StudentBalanceRequestDto request = new StudentBalanceRequestDto();
            request.setOrgId(orgId);
            request.setStudentId(studentId);
            request.setNeedBanlacneChangeRecords(false);
            boolean hasPermission = permissionService.checkPermission(orgId,cascadeId, DeviceType.APP, TXPermissionConst.STUDENT_ACCOUNT.getPCode());
            if(hasPermission){
                StudentBalanceResponseDto findStudentBalanceInfo = this.findStudentBalanceInfo(request);
                log.info("find findStudentBalanceInfo is:{} ", findStudentBalanceInfo);
                if (findStudentBalanceInfo != null) {
                    orgStudentInfoForKeXiao.setBalance(findStudentBalanceInfo.getBalance());
                }
            }else {
                orgStudentInfoForKeXiao.setAllowViewBalance(1);
            }

        }
        return orgStudentInfoForKeXiao;
    }

    @Override
    public StudentBalanceResponseDto findStudentBalanceInfo(StudentBalanceRequestDto request) {
        log.info("StudentBalanceRequestDto is :{} ", request);
        Long orgId = request.getOrgId();
        Long studentId = request.getStudentId();
        List<OrgStudent> studentByIds = this.orgStudentDao.getStudentByIds(orgId, Arrays.asList(studentId));
        OrgStudent orgStudent = null;
        if (GenericsUtils.notNullAndEmpty(studentByIds)) {
            orgStudent = studentByIds.get(0);
        } else {
            throw new BussinessException(CommonErrorCode.NOT_FOUND,
                    String.format("can not find student with id :%s ", studentId));
        }

        String mobile = orgStudent.getMobile();
        final boolean isShow = txCascadeCredentialService.isShowMobile(orgId, request.getCascadeId());
        if (!isShow) {
            mobile = MaskUtil.maskMobile(mobile);
        }
        StudentBalanceResponseDto studentBalanceResponseDto =
                this.txStudentFinanceAccountService.findStudentBalanceResponseDto(request);
        studentBalanceResponseDto.setStudentId(studentId);
        studentBalanceResponseDto.setMobile(mobile);
        studentBalanceResponseDto.setStudentName(orgStudent.getNotEmptyName());
        return studentBalanceResponseDto;
    }

    public OrgStudentResponse getOrgStudentInfoForKeXiao(Long studentId, Integer cascadeId, Long orgId,
                                                         Integer applicationType, boolean needSetClassHour) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
            // 添加学员的来源和归属人
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                    buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            studentCommenRequestDto.setNeedSetClassHour(needSetClassHour);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = orgStudentService.getStudentInfo(studentCommenRequestDto, orgId, cascadeId);
            log.info("studentInfoDto param:{}", studentInfoDto);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", orgStudentInfo.getProvince());
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        }

        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }

        });
        // 添加学员两个自定义字段
        addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);

        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);

        // 规则判断 是否可以发短信
        TXCascadeAccount loginer = null;
        if (cascadeId != null && cascadeId > 0) {
            loginer = txCascadeAccountDao.getById(cascadeId);
        }

        if (loginer != null
                && (CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.DIRECTOR
                || CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.STAFF)) {
            TXCommonRule txCommonRule = txCommonRuleService.getByOrgId(orgId.intValue());
            if (txCommonRule.getStudentMobileRule().intValue() == 1) {
                reponse.setAllowToSms(Flag.FALSE.getInt());
            }
        } else {
            reponse.setAllowToSms(Flag.TRUE.getInt());
        }

        return reponse;
    }

    /**
     * @param orgStudentInfo
     * @param orgId
     * @param studentId
     */
    private void addSpecialFieldForStudent(OrgStudentInfo orgStudentInfo, Integer cascadeId, Integer orgId,
                                           Long studentId) {
        Long cascadeLong = 0L;
        if (cascadeId != null) {
            cascadeLong = cascadeId.longValue();
        }

        List<FieldOption> optionList = new ArrayList<>();
        // 设置归属人列表
        List<TxCascadeCredentialSelectionDto> list = this.orgTxCascadeCredentialService.getTxCascadeCredentialList(
                orgId, 0L, CascadeSearchSource.STUDENT_FILTER, new AccountSelectionDto());
        log.info("find all list : {} ", list);
        Integer addCascadeId = orgStudentInfo.getCascadeId();
        log.info("addCascadeSingle is :{} ", addCascadeId);
        FieldOption cascadeSingle = null;
        cascadeSingle = new FieldOption();
        boolean canEdit = false;
        Integer cascadeForShow = -1;
        if (studentId == -1) {
            canEdit = true;
            cascadeForShow = cascadeLong.intValue();
        } else {
            cascadeForShow = addCascadeId;
        }
        log.info("fieldOptins is :{} ", cascadeSingle);
        SpecialFieldEnum sfe = SpecialFieldEnum.STU_ADD_CASCADE_ID;
        CustomFieldValueResponse response =
                new CustomFieldValueResponse(sfe.getKey(), sfe.getLabel(), sfe.getSectionId(), cascadeSingle,
                        RequireStatus.NOT_REQUIRE.getStatus(), CustomFieldType.SINGLE_CHOICE.getType());
        if (GenericsUtils.notNullAndEmpty(list)) {
            for (TxCascadeCredentialSelectionDto tcsd : list) {
                String name = tcsd.getName();
                Integer cascadeId2 = tcsd.getCascadeId();
                FieldOption fo = new FieldOption(cascadeId2.longValue(), name);
                optionList.add(fo);
                log.info("TxCascadeCredentialSelectionDto is :{} and is Match:{} ", tcsd,
                        tcsd.getCascadeId() == addCascadeId);
                if (cascadeId2.equals(cascadeForShow)) {
                    log.info("find a match tcsd:{} ", tcsd);
                    cascadeSingle.setId(cascadeId2.longValue());
                    cascadeSingle.setValue(tcsd.getName());
                }
            }
            if (canEdit) {
                response.setOptions(optionList);
            }
        }
        log.info("response is :{} ", response);
        orgStudentInfo.getFields().add(response);

        List<FieldOption> optionListOfSource = new ArrayList<>();
        sfe = SpecialFieldEnum.STU_SOURCE;
        // 设置学员来源列表
        Integer source = orgStudentInfo.getSource();
        FieldOption sectionOption = null;
        if (source != null) {
            Long stuSourceId = Long.parseLong(source + "");
            log.info("source is :{} ", stuSourceId);
            sectionOption = new FieldOption(stuSourceId, this.consultSourceService.getConsultSourceStr(stuSourceId));
            log.info("FieldOptin is : {} ", sectionOption);
        }
        CustomFieldValueResponse reponseOfSource =
                new CustomFieldValueResponse(sfe.getKey(), sfe.getLabel(), sfe.getSectionId(), sectionOption,
                        RequireStatus.NOT_REQUIRE.getStatus(), CustomFieldType.SINGLE_CHOICE.getType());
        List<ConsultCustomSourceDto> consultCustomSourceDtos = consultSourceService.selection(orgId.longValue(),
                saleClueRuleService.getByOrgId(orgId.intValue()), null, PauseStatus.NOT_PAUSE.getStatus());
        if (GenericsUtils.notNullAndEmpty(consultCustomSourceDtos)) {
            for (ConsultCustomSourceDto consultCustomSourceDto : consultCustomSourceDtos) {
                FieldOption option = new FieldOption(consultCustomSourceDto.getId(), consultCustomSourceDto.getLabel());
                optionListOfSource.add(option);
            }
        }
        reponseOfSource.setOptions(optionListOfSource);
        orgStudentInfo.getFields().add(reponseOfSource);
    }

    /**
     */
    @Override
    public OrgStudentResponse getOrgStudentInfoWithCallback(Long studentId, Integer cascadeId, Long orgId,
                                                            Integer applicationType, boolean systemOnly, SetInfoCallback<StudentInfoDto> callback) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                    buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            studentCommenRequestDto.setNeedSetClassHour(false);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            // 设置基本信息
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);

            if (callback == null) {
                callback = new DefaultSetInfoCallback(this.orgStudentService);
            }
            callback.init();

            Map<String, Object> params = Maps.newHashMap();
            params.put("orgId", orgId);
            params.put("cascadeId", cascadeId);
            params.put("applicationType", applicationType);
            params.put("userId", studentInfoDto.getUserId());
            params.put("studentId", studentId);
            params.put("isShowMobile", studentInfoDto.getIsShowMobile());
            callback.setInfos(studentInfoDto, params);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId, systemOnly);
        }

        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        // 添加学员两个自定义字段
        addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    /**
     * @param studentId
     * @param orgId
     * @param reponse
     */
    @Override
    public void fillStatistics(Long studentId, Long orgId, OrgStudentResponse reponse) {
        if (studentId == -1) {
            return;
        }
        StudentBalanceRequestDto request = new StudentBalanceRequestDto();
        request.setOrgId(orgId);
        request.setStudentId(studentId);
        request.setNeedBanlacneChangeRecords(false);
        StudentBalanceResponseDto findStudentBalanceResponseDto =
                this.txStudentFinanceAccountService.findStudentBalanceResponseDto(request);
        if (findStudentBalanceResponseDto != null) {
            double balance = findStudentBalanceResponseDto.getBalance();
            reponse.setBalance(balance);
        } else {
            reponse.setBalance(0.0);
        }
        Collection<? extends KexiaoStatisticsSuper> studentRequest = Arrays.asList(reponse);
        this.studentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, studentRequest, 1);

        OrgStudent student = orgStudentDao.getById(studentId, "id", "userId");

        Map<Long, KexiaoStudentStat> statMap = kexiaoApiService.queryUserKexiaoStat(orgId, Arrays.asList(student.getUserId()));
        KexiaoStudentStat stat = statMap.get(student.getUserId());

        if (!reponse.isKexiaoFillOver()) {
            reponse.setTipInfo(TIP_STR);
            reponse.setTipInfoUrl(TIP_INFO_URL);
        }

        String remainTuition = kexiaoApiService.getLeftAmountStr(stat);
        long balance = 0;
        if (stat != null) {
            log.info(" reponse :{} ,contractAmount={},refundAmount={},transferAmount={}", reponse,stat.getContractAmount(),stat.getRefundAmount(),stat.getTransferAmount());
            balance += (stat.getContractAmount() - stat.getRefundAmount() - stat.getTransferAmount());
        }

        TxStudentFinanceAccount account = studentFinanceAccountDao.getFinanceAccount(orgId, studentId);

        if(account!=null){
            balance += account.getBalance();
        }
        double payMoney = Double.parseDouble(NumberUtil.convertFenToYuan(balance));
        reponse.setPayMoney(NumberUtil.get2Double(payMoney));
        reponse.setRemainTuition(remainTuition);
    }

    @Override
    public OrgStudentResponse getOrgStudentBase1Info(Long studentId, Integer cascadeId, Long orgId,
                                                     Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                    buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            // 设置基本信息
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            // 设置跟进记录
            this.orgStudentService.setStudentComment(studentInfoDto.getUserId(), orgId,
                    studentInfoDto.getIsShowMobile(), studentInfoDto);
            // 机构是否可以与学员进行微信聊天
            this.orgStudentService.setFansInfo(studentId, orgId, studentInfoDto);
            // 设置学员标签信息
            this.orgStudentService.setStudentTags(studentInfoDto.getUserId(), orgId, studentInfoDto);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", orgStudentInfo.getProvince());
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        }

        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }

        });
        // 添加学员两个自定义字段
        addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    private OrgStudentResponse buildOrgStudentResponse(OrgStudentInfo orgStudentInfo) {
        OrgStudentResponse reponse = new OrgStudentResponse();
        BeanUtils.copyProperties(orgStudentInfo, reponse);
        return reponse;
    }

    private StudentCommenRequestDto buidStudentCommenRequestDto(Long studentId, Integer cascadeId, Long orgId,
                                                                Integer applicationType) {
        StudentCommenRequestDto dto = new StudentCommenRequestDto();
        dto.setStudentId(studentId);
        dto.setCasCadeId(cascadeId);
        dto.setOrgId(orgId);
        dto.setIsStudent(true);
        dto.setApplicationType(applicationType);
        return dto;
    }

    private OrgStudentInfo buildOrgStudentInfo(StudentInfoDto studentInfoDto) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        BeanUtils.copyProperties(studentInfoDto, orgStudentInfo);
        orgStudentInfo.setSex(studentInfoDto.getGender());
        orgStudentInfo.setCascadeId(studentInfoDto.getAddCascadeId());
        TXAddressBookDto txAddressBookDto=studentInfoDto.getAddressDetail();
        String addressDetail= JacksonUtil.obj2Str(txAddressBookDto);

        orgStudentInfo.setAddressDetail(addressDetail);
        return orgStudentInfo;
    }

    @Override
    @Transactional
    public Long saveOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId) {
        Long studentId = orgStudentInfo.getStudentId();
        orgStudentInfo.setIsStudent(true);
        orgStudentInfo.setCascadeId(cascadeId);
        // 保存自定义字段
        List<Long> fieldValueIds =
                customFieldValueService.saveOrUpdateCustomFieldValues(orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = buildStudentInfoDto(orgStudentInfo);
        saveSpecialFieldFoeStudent(orgStudentInfo.getFields(), studentInfoDto);
        List<TagInfoDto> tagList = studentInfoDto.getTagsResp();

        if (studentId != null && studentId > 0) {
            List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
            orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
        } else {
            List<CustomFieldValue> customFieldValues = customFieldValueDao.getByIds(fieldValueIds);
            OrgStudentAddresponseDto response = orgStudentService.addStudent(studentInfoDto, null, tagList, orgId);
            log.info("will addUnifiedWechatBindConsulter for orgStudentInfo :{} ", orgStudentInfo);
            addUnifiedWechatBindConsulter(orgStudentInfo, orgId);
            studentId = response.getStudentId();
            // 当首次保存学员时，自定义字段中studentId需要修改
            if (GenericsUtils.notNullAndEmpty(fieldValueIds)) {

                for (CustomFieldValue fieldValue : customFieldValues) {
                    fieldValue.setStudentId(studentId);
                    customFieldValueDao.update(fieldValue, "studentId");
                }
            }
        }
        List<CustomFieldValue> allCustomFieldValues =
                customFieldValueDao.searchValuesByConfig(orgId, true, studentId, null);
        String customSearchValue =
                studentUserService.buildCustomSearchValue(allCustomFieldValues, false, false, null, null, null);
        OrgStudent student = new OrgStudent();
        student.setId(studentId);
        student.setCustomSearchValue(customSearchValue);
        orgStudentDao.update(student, true, "customSearchValue");

        return studentId;
    }
    @Override
    @Transactional
    public Long saveOrgStudentInfo2(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId) {
        Long studentId = orgStudentInfo.getStudentId();
        orgStudentInfo.setIsStudent(true);
        orgStudentInfo.setCascadeId(cascadeId);
        // 保存自定义字段
        List<Long> fieldValueIds =
                customFieldValueService.saveOrUpdateCustomFieldValues(orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = buildStudentInfoDto(orgStudentInfo);
        TXAddressBookDto txAddressBookDto=studentInfoDto.getAddressDetail();
        if(!GenericsUtils.isNullOrEmpty(txAddressBookDto)) {
            if (txAddressBookDto.getUnit() != null && EmojiUtil.containsEmoji(txAddressBookDto.getUnit())) {
                throw new ParameterException(CommonErrorCode.PARAM_ERROR, "地址不能含有表情符号");
            }
        }


        saveSpecialFieldFoeStudent(orgStudentInfo.getFields(), studentInfoDto);
        List<TagInfoDto> tagList = studentInfoDto.getTagsResp();

        if (studentId != null && studentId > 0) {
            List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
            orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
        } else {
            List<CustomFieldValue> customFieldValues = customFieldValueDao.getByIds(fieldValueIds);
            OrgStudentAddresponseDto response = orgStudentService.addStudent(studentInfoDto, null, tagList, orgId);
            log.info("will addUnifiedWechatBindConsulter for orgStudentInfo :{} ", orgStudentInfo);
            addUnifiedWechatBindConsulter(orgStudentInfo, orgId);
            studentId = response.getStudentId();
            // 当首次保存学员时，自定义字段中studentId需要修改
            if (GenericsUtils.notNullAndEmpty(fieldValueIds)) {

                for (CustomFieldValue fieldValue : customFieldValues) {
                    fieldValue.setStudentId(studentId);
                    customFieldValueDao.update(fieldValue, "studentId");
                }
            }
        }
        List<CustomFieldValue> allCustomFieldValues =
                customFieldValueDao.searchValuesByConfig(orgId, true, studentId, null);
        String customSearchValue =
                studentUserService.buildCustomSearchValue(allCustomFieldValues, false, false, null, null, null);
        OrgStudent student = new OrgStudent();
        student.setId(studentId);
        student.setCustomSearchValue(customSearchValue);
        orgStudentDao.update(student, true, "customSearchValue");

        return studentId;
    }
    /**
     * 在添加
     *
     * @param orgStudentInfo
     * @param orgId
     */
    private void addUnifiedWechatBindConsulter(OrgStudentInfo orgStudentInfo, Long orgId) {
        String mobile = orgStudentInfo.getMobile();
        if (GenericsUtils.isNullOrEmpty(mobile)) {
            return;
        }
        UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId =
                this.unifiedWechatAccountService.findMasterAccountWithAnyCampusOrgId(orgId.intValue(), true);
        log.info("orgId :{} findMasterAccount is :{} ", orgId, findMasterAccountWithAnyCampusOrgId);
        if (findMasterAccountWithAnyCampusOrgId != null) {
            String weixin = orgStudentInfo.getWeixin();
            if (GenericsUtils.isNullOrEmpty(weixin)) {
                weixin = this.unifiedWechatAccountService
                        .findWeixinFromCampusOrgWithMobile(findMasterAccountWithAnyCampusOrgId.getOrgId(), mobile, true);
            }
            if (GenericsUtils.notNullAndEmpty(mobile)) {
                log.info("find weixin for orgId :{} with mobile:{} ", orgId, mobile);
                if (GenericsUtils.notNullAndEmpty(weixin)) {
                    List<StudentInfoDto> andUpdateOrgStudentByMobile =
                            this.orgStudentService.getAndUpdateOrgStudentByMobile(orgId, mobile, "", weixin);
                    log.info("auth bind weixin:{} with orgStudetn:{} ", weixin, andUpdateOrgStudentByMobile);
                }
            }
        }
    }

    /**
     * @param fields
     * @param studentInfoDto
     */
    private void saveSpecialFieldFoeStudent(List<CustomFieldDto> fields, StudentInfoDto studentInfoDto) {
        if (GenericsUtils.notNullAndEmpty(fields)) {
            for (CustomFieldDto cf : fields) {
                CustomFieldValueRequest request = (CustomFieldValueRequest) cf;
                SpecialFieldEnum consultFieldEnum = SpecialFieldEnum.getSpecialFieldEnum(request.getKey());
                if (consultFieldEnum != null) {
                    setSpecialFieldValueByKey(consultFieldEnum, request.getValues(), studentInfoDto);
                }
            }
        }
    }

    /**
     * @param consultFieldEnum
     * @param values
     * @param studentInfoDto
     */
    private void setSpecialFieldValueByKey(SpecialFieldEnum consultFieldEnum, Map<String, Object> values,
                                           StudentInfoDto studentInfoDto) {
        log.info("[SutdentCustomField] Map<String, Object> values param:{}", values);
        switch (consultFieldEnum) {
            // 设置学员的归属人
            case STU_ADD_CASCADE_ID:
                if (values != null && values.get("id") != null) {
                    studentInfoDto.setAddCascadeId((Integer) values.get("id"));
                }
                break;
            // 设置学员的来源
            case STU_SOURCE:
                if (values != null && values.get("id") != null) {
                    studentInfoDto.setSource((Integer) values.get("id"));
                }
                break;
            default:
                return;
        }
    }

    private StudentInfoDto buildStudentInfoDto(OrgStudentInfo orgStudentInfo) {
        StudentInfoDto studentInfoDto = new StudentInfoDto();
        BeanUtils.copyProperties(orgStudentInfo, studentInfoDto);
        studentInfoDto.setGender(orgStudentInfo.getSex());
        String addressDetailstr=orgStudentInfo.getAddressDetail();
        try {
            if(!GenericsUtils.isNullOrEmpty(addressDetailstr)) {
                TXAddressBookDto txAddressBookDto = JacksonUtil.str2Obj(addressDetailstr, TXAddressBookDto.class);
                studentInfoDto.setAddressDetail(txAddressBookDto);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return studentInfoDto;
    }

    @Override
    @Transactional
    public void updateOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId) {
        // 更新自定义字段
        customFieldValueService.saveOrUpdateCustomFieldValues(orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = buildStudentInfoDto(orgStudentInfo);
        List<TagInfoDto> tagList = orgStudentInfo.getTagsResp();
        List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
        orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);

    }

    /**
     * @param sinupInfos
     * @return
     */
    public Map<Long, Float> findTotalBuyCount(List<OrgSignupInfo> sinupInfos) {
        Set<Long> signupPurchaseIds = Sets.newHashSet();
        List<Long> fieldList = GenericsUtils.toFieldList(sinupInfos, "signupPurchaseId");
        signupPurchaseIds.addAll(fieldList);
        List<OrgSignupCourse> coursePurchases =
                this.orgSignupCourseDao.loadByPurchaseIds(signupPurchaseIds, "signupPurchaseId", "orgCourseId");
        Set<Long> courseIds = Sets.newHashSet();
        List<Long> orgCourses = GenericsUtils.toFieldList(coursePurchases, "orgCourseId");
        courseIds.addAll(orgCourses);
        List<OrgCourse> courseList = this.orgCourseDao.getByIds(courseIds, "id", "name", "chargeType", "chargeUnit");
        Map<Long, OrgCourse> courseMap = GenericsUtils.toFieldMap(courseList, "id");
        Map<Long, Float> totalCountMap = Maps.newHashMap();
        for (OrgSignupCourse orgSignupCourse : coursePurchases) {
            Long courseId = orgSignupCourse.getOrgCourseId();
            OrgCourse oc = courseMap.get(courseId);
            float buyCount = findBuyCount(oc, orgSignupCourse);
            totalCountMap.put(courseId,
                    totalCountMap.get(courseId) == null ? 0 : totalCountMap.get(courseId) + buyCount);
        }
        return totalCountMap;
    }

    /**
     * @return
     */
    private float findBuyCount(OrgCourse oc, OrgSignupCourse osc) {
        int chargeType = oc.getChargeType();
        int chargeUnit = oc.getChargeUnit();
        int count = osc.getCount();
        if (ChargeType.chargeByPeriods(chargeType, chargeUnit)) { // 按期
            int times = count * oc.getFreq();
            return times;
        } else if (ChargeType.chargeByClassHour(chargeType, chargeUnit)) {// 按课时
            float totalCount = countClassHour(count, chargeUnit);
            return totalCount;
        } else if (ChargeType.chargeByTimes(chargeType, chargeUnit)) { // 按课次
            return count;
        }
        return 0;
    }

    /**
     * @param count
     * @param chargeUnit
     * @return
     */
    private static float countClassHour(int count, int chargeUnit) {
        if (chargeUnit == ChargeUnit.BY_HALF_HOUR.getCode()) {
            BigDecimal b1 = new BigDecimal(Float.toString(count * 5));
            BigDecimal b2 = new BigDecimal(Float.toString(10));
            return b1.divide(b2, 1, BigDecimal.ROUND_HALF_UP).floatValue();
        } else if (chargeUnit == ChargeUnit.BY_MINUTE.getCode()) {
            BigDecimal b1 = new BigDecimal(Float.toString(count));
            BigDecimal b2 = new BigDecimal(Float.toString(60));
            return b1.divide(b2, 1, BigDecimal.ROUND_HALF_UP).floatValue();
        }
        return count;
    }

    @Override
    public List<SimpleFieldDto> getDateList(Long orgId) {
        List<SimpleFieldDto> ret = new ArrayList<>();
        List<SystemFields> fieldsList = SystemFields.getFilterDateFields();
        for (SystemFields fields:fieldsList){
            SimpleFieldDto dto = new SimpleFieldDto();
            dto.setName(fields.label);
            dto.setKey(fields.nameList);
            ret.add(dto);
        }
        return ret;
    }

    @Override
    public Map<Long,List<TXCustomOption>> getOptions(Collection<Long> customFieldIds) {
        Map<Long,List<TXCustomOption>> retMap = new HashMap<>();
        List<TXCustomOption> options = optionDao.getTXCustomOptionList(customFieldIds);
        for (TXCustomOption option:options){
            if(retMap.get(option.getParentId())==null){
                List<TXCustomOption> list = new ArrayList<>();
                retMap.put(option.getParentId(),list);
            }
            retMap.get(option.getParentId()).add(option);
        }
        return retMap;
    }
}
