package com.baijia.tianxiao.biz.student.customStudentField.service;

import com.baijia.tianxiao.biz.student.dto.SetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentInfo;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentResponse;
import com.baijia.tianxiao.biz.student.dto.response.SimpleFieldDto;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.sal.signup.dto.request.StudentBalanceRequestDto;
import com.baijia.tianxiao.sal.signup.dto.response.StudentBalanceResponseDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Jul 19, 2016 10:16:37 PM
 * @desc : 用户自定义字段service
 */
public interface BizCustomFieldService {

    public Object listCustomFields(Long orgId, Integer customType);

    public Map<Long,List<TXCustomOption>> getOptions(Collection<Long> customFieldIds);

    /**
     * 获取学员详情 包括学员自定义字段
     * 
     * @param studentId
     * @param cascadeId
     * @param orgId
     * @return
     */
    public OrgStudentResponse getOrgStudentInfo(Long studentId, Integer cascadeId, Long orgId, Integer applicationType);

    /**
     * 保存学员详情，包括学员自定义字段值
     */
    public Long saveOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId);

    /**
     * 更新学员详情
     */
    public void updateOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId);

    /**
     * @param studentId
     * @param cascadeId
     * @param orgId
     * @param applicationType
     * @param systemOnly
     * @param callback
     * @return
     */
    OrgStudentResponse getOrgStudentInfoWithCallback(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType, boolean systemOnly, SetInfoCallback<StudentInfoDto> callback);

    /**
     * @param studentId
     * @param cascadeId
     * @param orgId
     * @param applicationType
     * @return
     */
    OrgStudentResponse getOrgStudentBase1Info(Long studentId, Integer cascadeId, Long orgId, Integer applicationType);

    /**
     * @param studentId
     * @param cascadeId
     * @param orgId
     * @param applicationType
     * @return
     */
        
    OrgStudentResponse getOrgStudentInfoForKeXiao(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType);

    /**
     * @param request
     * @return
     */
    StudentBalanceResponseDto findStudentBalanceInfo(StudentBalanceRequestDto request);

    /**
     * @param studentId
     * @param orgId
     * @param reponse
     */
    void fillStatistics(Long studentId, Long orgId, OrgStudentResponse reponse);

    List<SimpleFieldDto> getDateList(Long orgId);
    Long saveOrgStudentInfo2(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId);

}
