/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.student.customStudentField.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.baijia.tianxiao.biz.student.customStudentField.service.BizCustomFieldService;
import com.baijia.tianxiao.biz.student.dto.DefaultSetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.SetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentInfo;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentResponse;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.CampusAccountType;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.org.po.TXCommonRule;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.organization.constant.CascadeSearchSource;
import com.baijia.tianxiao.sal.organization.org.dto.AccountSelectionDto;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialSelectionDto;
import com.baijia.tianxiao.sal.organization.org.service.TXCommonRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueRequest;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldValueResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.RequireStatus;
import com.baijia.tianxiao.sal.student.enums.SpecialFieldEnum;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年7月28日
 * @desc
 */
@Service
@Slf4j
public class BizCustomFieldServiceImpl implements BizCustomFieldService {
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TxCascadeCredentialService orgTxCascadeCredentialService;
    @Autowired
    private ConsultSourceService consultSourceService;
    @Autowired
    private TXSaleClueRuleService saleClueRuleService;
    
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCommonRuleService txCommonRuleService;

    @Override
    public Object listCustomFields(Long orgId, Integer customType) {
        return null;
    }

    @Override
    public OrgStudentResponse getOrgStudentInfo(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
            // 添加学员的来源和归属人
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = orgStudentService.getStudentInfo(studentCommenRequestDto, orgId, cascadeId);
            log.info("studentInfoDto param:{}", studentInfoDto);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", orgStudentInfo.getProvince());
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        }

        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }

        });
        // 添加学员两个自定义字段
        addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);

        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);
        
        // 规则判断 是否可以发短信
        TXCascadeAccount loginer = null;
        if (cascadeId!=null && cascadeId>0){
        	loginer = txCascadeAccountDao.getById(cascadeId);
        }
        
        if (loginer!=null
        		&& 
        	( CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.DIRECTOR
        	||CampusAccountType.getTypeByCode(loginer.getAccountType().intValue()) == CampusAccountType.STAFF)){
        	
        	TXCommonRule txCommonRule = txCommonRuleService.getByOrgId(orgId.intValue());
        	if(txCommonRule.getStudentMobileRule().intValue() == 1) {
        		reponse.setAllowToSms(Flag.FALSE.getInt());
        	}
        }else{
        	reponse.setAllowToSms(Flag.TRUE.getInt());
        }
        
        return reponse;
    }

    /**
     * @param orgStudentInfo
     * @param orgId
     * @param studentId
     */
    private void addSpecialFieldForStudent(OrgStudentInfo orgStudentInfo, Integer cascadeId, Integer orgId,
        Long studentId) {
        Long cascadeLong = 0L;
        if (cascadeId != null) {
            cascadeLong = cascadeId.longValue();
        }

        List<FieldOption> optionList = new ArrayList<>();
        // 设置归属人列表
        List<TxCascadeCredentialSelectionDto> list = this.orgTxCascadeCredentialService.getTxCascadeCredentialList(
            orgId, cascadeLong, CascadeSearchSource.STUDENT_FILTER, new AccountSelectionDto());
        log.info("find all list : {} ", list);
        Integer addCascadeId = orgStudentInfo.getAddCascadeId();
        log.info("addCascadeSingle is :{} ", addCascadeId);
        FieldOption cascadeSingle = null;
        cascadeSingle = new FieldOption();
        boolean canEdit = false;
        Integer cascadeForShow = -1;
        if (studentId == -1) {
            canEdit = true;
            cascadeForShow = cascadeLong.intValue();
        } else {
            cascadeForShow = addCascadeId;
        }
        log.info("fieldOptins is :{} ", cascadeSingle);
        SpecialFieldEnum sfe = SpecialFieldEnum.STU_ADD_CASCADE_ID;
        CustomFieldValueResponse response =
            new CustomFieldValueResponse(sfe.getKey(), sfe.getLabel(), sfe.getSectionId(), cascadeSingle,
                RequireStatus.NOT_REQUIRE.getStatus(), CustomFieldType.SINGLE_CHOICE.getType());
        if (GenericsUtils.notNullAndEmpty(list)) {
            for (TxCascadeCredentialSelectionDto tcsd : list) {
                String name = tcsd.getName();
                Integer cascadeId2 = tcsd.getCascadeId();
                FieldOption fo = new FieldOption(cascadeId2.longValue(), name);
                optionList.add(fo);
                log.info("TxCascadeCredentialSelectionDto is :{} and is Match:{} ", tcsd,
                    tcsd.getCascadeId() == addCascadeId);
                if (cascadeId2.equals(cascadeForShow)) {
                    log.info("find a match tcsd:{} ", tcsd);
                    cascadeSingle.setId(cascadeId2.longValue());
                    cascadeSingle.setValue(tcsd.getName());
                }
            }
            if (canEdit) {
                response.setOptions(optionList);
            }
        }
        log.info("response is :{} ", response);
        orgStudentInfo.getFields().add(response);

        List<FieldOption> optionListOfSource = new ArrayList<>();
        sfe = SpecialFieldEnum.STU_SOURCE;
        // 设置学员来源列表
        Integer source = orgStudentInfo.getSource();
        FieldOption sectionOption = null;
        if (source != null) {
            Long stuSourceId = Long.parseLong(source + "");
            log.info("source is :{} ", stuSourceId);
            sectionOption = new FieldOption(stuSourceId, this.consultSourceService.getConsultSourceStr(stuSourceId));
            log.info("FieldOptin is : {} ", sectionOption);
        }
        CustomFieldValueResponse reponseOfSource =
            new CustomFieldValueResponse(sfe.getKey(), sfe.getLabel(), sfe.getSectionId(), sectionOption,
                RequireStatus.NOT_REQUIRE.getStatus(), CustomFieldType.SINGLE_CHOICE.getType());
        List<ConsultCustomSourceDto> consultCustomSourceDtos = consultSourceService.selection(orgId.longValue(),
            saleClueRuleService.getByOrgId(orgId.intValue()), null, PauseStatus.NOT_PAUSE.getStatus());
        if (GenericsUtils.notNullAndEmpty(consultCustomSourceDtos)) {
            for (ConsultCustomSourceDto consultCustomSourceDto : consultCustomSourceDtos) {
                FieldOption option = new FieldOption(consultCustomSourceDto.getId(), consultCustomSourceDto.getLabel());
                optionListOfSource.add(option);
            }
        }
        reponseOfSource.setOptions(optionListOfSource);
        orgStudentInfo.getFields().add(reponseOfSource);
    }

    /**
     */
    @Override
    public OrgStudentResponse getOrgStudentInfoWithCallback(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType, boolean systemOnly, SetInfoCallback<StudentInfoDto> callback) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            // 设置基本信息
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);

            if (callback == null) {
                callback = new DefaultSetInfoCallback(this.orgStudentService);
            }
            callback.init();

            Map<String, Object> params = Maps.newHashMap();
            params.put("orgId", orgId);
            params.put("cascadeId", cascadeId);
            params.put("applicationType", applicationType);
            params.put("userId", studentInfoDto.getUserId());
            params.put("studentId", studentId);
            params.put("isShowMobile", studentInfoDto.getIsShowMobile());
            callback.setInfos(studentInfoDto, params);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId, systemOnly);
        }

        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        // 添加学员两个自定义字段
        addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    @Override
    public OrgStudentResponse getOrgStudentBase1Info(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            // 设置基本信息
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            // 设置跟进记录
            this.orgStudentService.setStudentComment(studentInfoDto.getUserId(), orgId,
                studentInfoDto.getIsShowMobile(), studentInfoDto);
            // 机构是否可以与学员进行微信聊天
            this.orgStudentService.setFansInfo(studentId, orgId, studentInfoDto);
            // 设置学员标签信息
            this.orgStudentService.setStudentTags(studentInfoDto.getUserId(), orgId, studentInfoDto);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", orgStudentInfo.getProvince());
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        }

        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }

        });
        // 添加学员两个自定义字段
        addSpecialFieldForStudent(orgStudentInfo, cascadeId, orgId.intValue(), studentId);
        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    private OrgStudentResponse buildOrgStudentResponse(OrgStudentInfo orgStudentInfo) {
        OrgStudentResponse reponse = new OrgStudentResponse();
        BeanUtils.copyProperties(orgStudentInfo, reponse);
        return reponse;
    }

    private StudentCommenRequestDto buidStudentCommenRequestDto(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType) {
        StudentCommenRequestDto dto = new StudentCommenRequestDto();
        dto.setStudentId(studentId);
        dto.setCasCadeId(cascadeId);
        dto.setOrgId(orgId);
        dto.setIsStudent(true);
        dto.setApplicationType(applicationType);
        return dto;
    }

    private OrgStudentInfo buildOrgStudentInfo(StudentInfoDto studentInfoDto) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        BeanUtils.copyProperties(studentInfoDto, orgStudentInfo);
        orgStudentInfo.setSex(studentInfoDto.getGender());
        return orgStudentInfo;
    }

    @Override
    @Transactional
    public Long saveOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId) {
        Long studentId = orgStudentInfo.getStudentId();
        orgStudentInfo.setIsStudent(true);
        orgStudentInfo.setAddCascadeId(cascadeId);
        // 保存自定义字段
        List<Long> fieldValueIds =
            customFieldValueService.saveOrUpdateCustomFieldValues(orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = buildStudentInfoDto(orgStudentInfo);
        saveSpecialFieldFoeStudent(orgStudentInfo.getFields(), studentInfoDto);
        List<TagInfoDto> tagList = studentInfoDto.getTagsResp();
        if (studentId != null && studentId > 0) {
            List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
            orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
        } else {
            OrgStudentAddresponseDto response = orgStudentService.addStudent(studentInfoDto, null, tagList, orgId);
            studentId = response.getStudentId();
            // 当首次保存学员时，自定义字段中studentId需要修改
            if (GenericsUtils.notNullAndEmpty(fieldValueIds)) {
                List<CustomFieldValue> customFieldValues = customFieldValueDao.getByIds(fieldValueIds);
                for (CustomFieldValue fieldValue : customFieldValues) {
                    fieldValue.setStudentId(studentId);
                    customFieldValueDao.update(fieldValue, "studentId");
                }
            }
        }

        return studentId;
    }

    /**
     * @param fields
     * @param studentInfoDto
     */
    private void saveSpecialFieldFoeStudent(List<CustomFieldDto> fields, StudentInfoDto studentInfoDto) {
        if (GenericsUtils.notNullAndEmpty(fields)) {
            for (CustomFieldDto cf : fields) {
                CustomFieldValueRequest request = (CustomFieldValueRequest) cf;
                SpecialFieldEnum consultFieldEnum = SpecialFieldEnum.getSpecialFieldEnum(request.getKey());
                if (consultFieldEnum != null) {
                    setSpecialFieldValueByKey(consultFieldEnum, request.getValues(), studentInfoDto);
                }
            }
        }
    }

    /**
     * @param consultFieldEnum
     * @param values
     * @param studentInfoDto
     */
    private void setSpecialFieldValueByKey(SpecialFieldEnum consultFieldEnum, Map<String, Object> values,
        StudentInfoDto studentInfoDto) {
        log.info("[SutdentCustomField] Map<String, Object> values param:{}", values);
        switch (consultFieldEnum) {
            // 设置学员的归属人
            case STU_ADD_CASCADE_ID:
                if (values != null && values.get("id") != null) {
                    studentInfoDto.setAddCascadeId((Integer) values.get("id"));
                }
                break;
            // 设置学员的来源
            case STU_SOURCE:
                if (values != null && values.get("id") != null) {
                    studentInfoDto.setSource((Integer) values.get("id"));
                }
                break;
            default:
                return;
        }
    }

    private StudentInfoDto buildStudentInfoDto(OrgStudentInfo orgStudentInfo) {
        StudentInfoDto studentInfoDto = new StudentInfoDto();
        BeanUtils.copyProperties(orgStudentInfo, studentInfoDto);
        studentInfoDto.setGender(orgStudentInfo.getSex());
        return studentInfoDto;
    }

    @Override
    @Transactional
    public void updateOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId) {
        // 更新自定义字段
        customFieldValueService.saveOrUpdateCustomFieldValues(orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = buildStudentInfoDto(orgStudentInfo);
        List<TagInfoDto> tagList = orgStudentInfo.getTagsResp();
        List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
        orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);

    }

}
