package com.baijia.tianxiao.biz.student.service.impl;

import com.baijia.tianxiao.biz.student.service.BizOrgStudentService;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Set;

/**
 * Created by liuxp on 16/9/23.
 */
@Service
@Slf4j
public class BizOrgStudentServiceImpl implements BizOrgStudentService{

    @Autowired
    private OrgStudentService studentService;
    @Autowired
    private CourseStudentService courseStudentService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delStudent(StudentCommenRequestDto requestDto, Long orgId) {
        studentService.delStudent(requestDto, orgId);
        courseStudentService.deleteOrgCourseStudentForDelStudent(orgId,requestDto.getStudentId());
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void batchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        if (CollectionUtils.isNotEmpty(studentIds)) {
            for (Long studentId : studentIds) {
                StudentCommenRequestDto requestDto = new StudentCommenRequestDto();
                requestDto.setStudentId(studentId);
                this.delStudent(requestDto,orgId);
            }
        }
    }
}
