/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.student.customStudentField.service.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.student.customStudentField.service.BizCustomFieldService;
import com.baijia.tianxiao.biz.student.dto.DefaultSetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.SetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentInfo;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentResponse;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年7月28日
 * @desc
 */
@Service
@Slf4j
public class BizCustomFieldServiceImpl implements BizCustomFieldService {
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;

    @Override
    public Object listCustomFields(Long orgId, Integer customType) {
        return null;
    }

    @Override
    public OrgStudentResponse getOrgStudentInfo(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = orgStudentService.getStudentInfo(studentCommenRequestDto, orgId, cascadeId);
            log.info("studentInfoDto param:{}", studentInfoDto);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", orgStudentInfo.getProvince());
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        }

        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }

        });

        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    /**
     * @param resourceType ,请求数据的类型: 0:全部 1:
     */
    @Override
    public OrgStudentResponse getOrgStudentInfoWithCallback(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType, boolean systemOnly, SetInfoCallback<StudentInfoDto> callback) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            // 设置基本信息
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);

            if (callback == null) {
                callback = new DefaultSetInfoCallback(this.orgStudentService);
            }
            callback.init();

            Map<String, Object> params = Maps.newHashMap();
            params.put("orgId", orgId);
            params.put("cascadeId", cascadeId);
            params.put("applicationType", applicationType);
            params.put("userId", studentInfoDto.getUserId());
            params.put("studentId", studentId);
            params.put("isShowMobile", studentInfoDto.getIsShowMobile());
            callback.setInfos(studentInfoDto, params);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId, systemOnly);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }

        });
        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    @Override
    public OrgStudentResponse getOrgStudentBase1Info(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        // 如果studentId== -1时返回自定义排序字段
        if (studentId == -1) {
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        } else {
            // 获取学员详情
            StudentCommenRequestDto studentCommenRequestDto =
                buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            // 设置基本信息
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            // 设置跟进记录
            this.orgStudentService.setStudentComment(studentInfoDto.getUserId(), orgId,
                studentInfoDto.getIsShowMobile(), studentInfoDto);
            // 机构是否可以与学员进行微信聊天
            this.orgStudentService.setFansInfo(studentId, orgId, studentInfoDto);
            // 设置学员标签信息
            this.orgStudentService.setStudentTags(studentInfoDto.getUserId(), orgId, studentInfoDto);
            orgStudentInfo = buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", orgStudentInfo.getProvince());
            customFieldValueService.setCustomFieldValues(orgStudentInfo, orgId, true, studentId);
        }

        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>() {
            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }

        });
        OrgStudentResponse reponse = buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    private OrgStudentResponse buildOrgStudentResponse(OrgStudentInfo orgStudentInfo) {
        OrgStudentResponse reponse = new OrgStudentResponse();
        BeanUtils.copyProperties(orgStudentInfo, reponse);
        return reponse;
    }

    private StudentCommenRequestDto buidStudentCommenRequestDto(Long studentId, Integer cascadeId, Long orgId,
        Integer applicationType) {
        StudentCommenRequestDto dto = new StudentCommenRequestDto();
        dto.setStudentId(studentId);
        dto.setCasCadeId(cascadeId);
        dto.setOrgId(orgId);
        dto.setIsStudent(true);
        dto.setApplicationType(applicationType);
        return dto;
    }

    private OrgStudentInfo buildOrgStudentInfo(StudentInfoDto studentInfoDto) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        BeanUtils.copyProperties(studentInfoDto, orgStudentInfo);
        orgStudentInfo.setSex(studentInfoDto.getGender());
        return orgStudentInfo;
    }

    @Override
    @Transactional
    public Long saveOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId) {
        Long studentId = orgStudentInfo.getStudentId();
        orgStudentInfo.setIsStudent(true);
        // 保存自定义字段
        List<Long> fieldValueIds =
            customFieldValueService.saveOrUpdateCustomFieldValues(orgStudentInfo, orgStudentInfo.getStudentId(), orgId);

        StudentInfoDto studentInfoDto = buildStudentInfoDto(orgStudentInfo);

        List<TagInfoDto> tagList = studentInfoDto.getTagsResp();
        if (studentId != null && studentId > 0) {
            List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
            orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
        } else {
            studentInfoDto.setAddCascadeId(cascadeId);
            OrgStudentAddresponseDto response = orgStudentService.addStudent(studentInfoDto, null, tagList, orgId);
            studentId = response.getStudentId();
            // 当首次保存学员时，自定义字段中studentId需要修改
            if (GenericsUtils.notNullAndEmpty(fieldValueIds)) {
                List<CustomFieldValue> customFieldValues = customFieldValueDao.getByIds(fieldValueIds);
                for (CustomFieldValue fieldValue : customFieldValues) {
                    fieldValue.setStudentId(studentId);
                    customFieldValueDao.update(fieldValue, "studentId");
                }
            }
        }

        return studentId;
    }

    private StudentInfoDto buildStudentInfoDto(OrgStudentInfo orgStudentInfo) {
        StudentInfoDto studentInfoDto = new StudentInfoDto();
        BeanUtils.copyProperties(orgStudentInfo, studentInfoDto);
        studentInfoDto.setGender(orgStudentInfo.getSex());
        return studentInfoDto;
    }

    @Override
    @Transactional
    public void updateOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId) {
        // 更新自定义字段
        customFieldValueService.saveOrUpdateCustomFieldValues(orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = buildStudentInfoDto(orgStudentInfo);
        List<TagInfoDto> tagList = orgStudentInfo.getTagsResp();
        List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
        orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);

    }

}
