/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.student.msg.service.impl;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import com.aliyun.mns.client.CloudQueue;
import com.aliyun.mns.common.ClientException;
import com.aliyun.mns.model.Message;
import com.baijia.tianxiao.biz.student.msg.service.OrgStudentMessageConsumeService;
import com.baijia.tianxiao.biz.student.msg.service.RosterMessageConsumeService;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

/**
 * @title PullMsgFromQueue
 * @desc TODO
 * @author cxm
 * @date 2015年12月8日
 * @version 1.0
 */
@Slf4j
@Service
public class RosterMessageConsumeServiceImp
    implements InitializingBean, ApplicationContextAware, RosterMessageConsumeService {

    private ApplicationContext context;

    public static Map<Integer, OrgStudentMessageConsumeService> messageServiceMap = Maps.newHashMap();

    @Override
    public void consumeMessage(final CloudQueue queue) {
        log.info("start pop msg from queue:{}", queue.getQueueURL());
        while (true) {
            try {
                Message message = queue.popMessage(5);
                log.info("[Message] content = "+ ToStringBuilder.reflectionToString(message));
                if (message != null) {
                    log.info("get msg:{}", message.getMessageId());
                    if (consumeMessage(message)) {
                        log.info("msg:{} is success consume", message.getMessageId());
                        queue.deleteMessage(message.getReceiptHandle());
                    }
                } else {
                    log.info("no message sleep 5 s");
                    try {
                        Thread.sleep(5 * 1000l);
                    } catch (InterruptedException e) {
                    }
                }
            } catch (ClientException e) {
                log.error("catch msn client exception:", e);
                try {
                    // 遇到服务器一次,就休息20s,
                    Thread.sleep(5 * 1000);
                } catch (InterruptedException e1) {
                }
            } catch (Exception e) {
                log.error("pop msg from consult msg queue catch  exception:", e);
            }

        }
    }

    private boolean consumeMessage(Message message) {
        try {
            Integer msgType = getConsultMsgTypeFromMsgBody(message);
            return messageServiceMap.get(msgType).consumeMessage(message.getMessageBodyAsString().substring(2));
        } catch (IllegalArgumentException e) {
            log.error("illegal message:{}", e);
        } catch (Exception e) {
            log.error("consume message catch error:{},body str:{}", e, message.getMessageBodyAsString());
            log.error("consume message catch error:{}",e);
        }
        return false;

    }

    /**
     * 从消息体中解析消息类型,现在的消息体格式: 类型(1位) + "$" + 都是JSON字符串,
     * 
     * @param message
     * @return
     */
    private Integer getConsultMsgTypeFromMsgBody(Message message) {
        String messageBody = message.getMessageBodyAsString();
        if (StringUtils.isNoneBlank(messageBody) && messageBody.length() > 2) {
            String head = messageBody.substring(0, 2);
            if (head.endsWith("$")) {
                try {
                    return Integer.parseInt(head.substring(0, 1));
                } catch (NumberFormatException e) {
                    log.error("message head is illeagl format type$");
                    throw new IllegalArgumentException("message format is illegal");
                }
            } else {
                log.error("message head is illeagl format type$");
                throw new IllegalArgumentException("message format is illegal");
            }
        } else {
            log.error("message body is illegal:{}", messageBody);
            throw new IllegalArgumentException("message format is illegal");
        }

    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, OrgStudentMessageConsumeService> serviceMap =
            context.getBeansOfType(OrgStudentMessageConsumeService.class);
        for (OrgStudentMessageConsumeService service : serviceMap.values()) {
            messageServiceMap.put(service.getMessageType(), service);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

}
