/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.student.dto.response;

import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldSection;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年8月9日
 * @desc  自定义字段，添加学员详情时，只返回前端需要的字段  从orgStudentInfo抽取而来
 */
@Data
public class OrgStudentResponse {
    private Long consultUserId;
    
    private String consultUserIds;

    private Long studentId;
    
    private Long studentNumber;
    
    private Double payMoney; // 消费总额

    private Integer totalClassTime; // 总课次

    private Integer finishClassTime; // 已完成课次

    private Integer sumClasses;//已报班级
    
    private List<CommentInfoDto> commentsResp;
    
    // 机构是否可以与学员进行微信聊天
    private int chat = 0;
    
    private String province;   //省份

    private String city;  //市

    private String county;   //区
    
    private Integer areaId;  //地域id
    
    private String weixin;
    
    private List<CustomFieldSection> sections;
    private List<CustomFieldDto> fields = new ArrayList<>();
    
    private String headTeacher;

}
