/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.service.impl;

import com.baijia.tianxiao.biz.student.service.BizOrgStudentService;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizOrgStudentServiceImpl
implements BizOrgStudentService {
    private static final Logger log = LoggerFactory.getLogger(BizOrgStudentServiceImpl.class);
    @Autowired
    private OrgStudentService studentService;
    @Autowired
    private CourseStudentService courseStudentService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delStudent(StudentCommenRequestDto requestDto, Long orgId) {
        this.studentService.delStudent(requestDto, orgId);
        this.courseStudentService.deleteOrgCourseStudentForDelStudent(orgId, requestDto.getStudentId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public void batchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        if (CollectionUtils.isNotEmpty(studentIds)) {
            for (Long studentId : studentIds) {
                StudentCommenRequestDto requestDto = new StudentCommenRequestDto();
                requestDto.setStudentId(studentId);
                this.delStudent(requestDto, orgId);
            }
        }
    }
}

