/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.dto;

import com.baijia.tianxiao.biz.student.dto.SetInfoCallback;
import com.baijia.tianxiao.util.GenericsUtils;
import com.beust.jcommander.internal.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSetInfoCallback<T>
implements SetInfoCallback<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSetInfoCallback.class);
    private Map<Class<?>, String> fieldTypes = Maps.newHashMap();
    private boolean needFieldInit;
    private AtomicBoolean isInit = new AtomicBoolean(false);

    public AbstractSetInfoCallback() {
        this(false);
    }

    public AbstractSetInfoCallback(boolean needFieldInit) {
        this.needFieldInit = needFieldInit;
        if (needFieldInit) {
            Field[] declaredFields;
            for (Field field : declaredFields = this.getClass().getDeclaredFields()) {
                if (field.getModifiers() == 8) continue;
                Class<?> type = field.getType();
                this.fieldTypes.put(type.getClass(), field.getName());
            }
        }
    }

    @Override
    public void init(Object ... injects) {
        if (this.needFieldInit && this.isInit.compareAndSet(false, true)) {
            if (GenericsUtils.notNullAndEmpty((Object)injects)) {
                for (Object obj : injects) {
                    Class<?> objType = obj.getClass();
                    for (Class<?> fieldType : this.fieldTypes.keySet()) {
                        if (!fieldType.isAssignableFrom(objType)) continue;
                        this.invokeSetField(obj, this.fieldTypes.get(fieldType));
                    }
                }
            } else if (GenericsUtils.notNullAndEmpty(this.fieldTypes)) {
                throw new RuntimeException(String.format("un init for : %s for class:%s", this.fieldTypes.values(), this.getClass().getName()));
            }
        }
        this.isInit.compareAndSet(false, true);
    }

    private void invokeSetField(Object obj, String fieldName) {
        try {
            BeanUtils.setProperty((Object)this, (String)fieldName, (Object)obj);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public <V> V getParams(Map<String, Object> params, String key) {
        return (V)params.get(key);
    }

    @Override
    public void setInfos(T instance, Map<String, Object> params) {
        log.info("current setter whether init : {} ", (Object)this.isInit.get());
        if (this.isInit.get()) {
            this.setInfosInSub(instance, params);
        } else if (GenericsUtils.notNullAndEmpty(this.fieldTypes)) {
            throw new IllegalArgumentException(String.format("un init for : %s for class:%s", this.fieldTypes.values(), this.getClass().getName()));
        }
    }

    protected abstract void setInfosInSub(T var1, Map<String, Object> var2);
}

