/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.customStudentField.service.impl;

import com.baijia.tianxiao.biz.student.customStudentField.service.BizCustomFieldService;
import com.baijia.tianxiao.biz.student.dto.DefaultSetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.SetInfoCallback;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentInfo;
import com.baijia.tianxiao.biz.student.dto.response.OrgStudentResponse;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFieldValues.OrgUserBaseInfo;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizCustomFieldServiceImpl
implements BizCustomFieldService {
    private static final Logger log = LoggerFactory.getLogger(BizCustomFieldServiceImpl.class);
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;

    @Override
    public Object listCustomFields(Long orgId, Integer customType) {
        return null;
    }

    @Override
    public OrgStudentResponse getOrgStudentInfo(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = this.orgStudentService.getStudentInfo(studentCommenRequestDto, orgId, cascadeId);
            log.info("studentInfoDto param:{}", (Object)studentInfoDto);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", (Object)orgStudentInfo.getProvince());
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    @Override
    public OrgStudentResponse getOrgStudentInfoWithCallback(Long studentId, Integer cascadeId, Long orgId, Integer applicationType, boolean systemOnly, SetInfoCallback<StudentInfoDto> callback) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            if (callback == null) {
                callback = new DefaultSetInfoCallback(this.orgStudentService);
            }
            callback.init(new Object[0]);
            HashMap params = Maps.newHashMap();
            params.put("orgId", orgId);
            params.put("cascadeId", cascadeId);
            params.put("applicationType", applicationType);
            params.put("userId", studentInfoDto.getUserId());
            params.put("studentId", studentId);
            params.put("isShowMobile", studentInfoDto.getIsShowMobile());
            callback.setInfos(studentInfoDto, (Map<String, Object>)params);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId, systemOnly);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    @Override
    public OrgStudentResponse getOrgStudentBase1Info(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        orgStudentInfo.setIsStudent(true);
        if (studentId == -1L) {
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        } else {
            StudentCommenRequestDto studentCommenRequestDto = this.buidStudentCommenRequestDto(studentId, cascadeId, orgId, applicationType);
            log.info("studentCommenRequestDto param:{}", (Object)studentCommenRequestDto);
            StudentInfoDto studentInfoDto = new StudentInfoDto();
            this.orgStudentService.setStudentBaseInfo(studentId, orgId, cascadeId, studentInfoDto);
            this.orgStudentService.setStudentComment(studentInfoDto.getUserId(), orgId, studentInfoDto.getIsShowMobile(), studentInfoDto);
            this.orgStudentService.setFansInfo(studentId, orgId, studentInfoDto);
            this.orgStudentService.setStudentTags(studentInfoDto.getUserId(), orgId, studentInfoDto);
            orgStudentInfo = this.buildOrgStudentInfo(studentInfoDto);
            log.info("orgStudentInfo param:{}, city parm:{}", (Object)orgStudentInfo.getProvince());
            this.customFieldValueService.setCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgId, true, studentId);
        }
        Collections.sort(orgStudentInfo.getFields(), new Comparator<CustomFieldDto>(){

            @Override
            public int compare(CustomFieldDto o1, CustomFieldDto o2) {
                return -(o1.getSorted() - o2.getSorted());
            }
        });
        OrgStudentResponse reponse = this.buildOrgStudentResponse(orgStudentInfo);
        return reponse;
    }

    private OrgStudentResponse buildOrgStudentResponse(OrgStudentInfo orgStudentInfo) {
        OrgStudentResponse reponse = new OrgStudentResponse();
        BeanUtils.copyProperties((Object)((Object)orgStudentInfo), (Object)reponse);
        return reponse;
    }

    private StudentCommenRequestDto buidStudentCommenRequestDto(Long studentId, Integer cascadeId, Long orgId, Integer applicationType) {
        StudentCommenRequestDto dto = new StudentCommenRequestDto();
        dto.setStudentId(studentId);
        dto.setCasCadeId(cascadeId);
        dto.setOrgId(orgId);
        dto.setIsStudent(Boolean.valueOf(true));
        dto.setApplicationType(applicationType);
        return dto;
    }

    private OrgStudentInfo buildOrgStudentInfo(StudentInfoDto studentInfoDto) {
        OrgStudentInfo orgStudentInfo = new OrgStudentInfo();
        BeanUtils.copyProperties((Object)studentInfoDto, (Object)((Object)orgStudentInfo));
        orgStudentInfo.setSex(studentInfoDto.getGender());
        return orgStudentInfo;
    }

    @Override
    @Transactional
    public Long saveOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId, Integer cascadeId) {
        Long studentId = orgStudentInfo.getStudentId();
        orgStudentInfo.setIsStudent(true);
        List fieldValueIds = this.customFieldValueService.saveOrUpdateCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = this.buildStudentInfoDto(orgStudentInfo);
        List tagList = studentInfoDto.getTagsResp();
        if (studentId != null && studentId > 0L) {
            List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
            this.orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
        } else {
            studentInfoDto.setAddCascadeId(cascadeId);
            OrgStudentAddresponseDto response = this.orgStudentService.addStudent(studentInfoDto, null, tagList, orgId);
            studentId = response.getStudentId();
            if (GenericsUtils.notNullAndEmpty((Object)fieldValueIds)) {
                List customFieldValues = this.customFieldValueDao.getByIds((Collection)fieldValueIds, new String[0]);
                for (CustomFieldValue fieldValue : customFieldValues) {
                    fieldValue.setStudentId(studentId);
                    this.customFieldValueDao.update((Object)fieldValue, new String[]{"studentId"});
                }
            }
        }
        return studentId;
    }

    private StudentInfoDto buildStudentInfoDto(OrgStudentInfo orgStudentInfo) {
        StudentInfoDto studentInfoDto = new StudentInfoDto();
        BeanUtils.copyProperties((Object)((Object)orgStudentInfo), (Object)studentInfoDto);
        studentInfoDto.setGender(orgStudentInfo.getSex());
        return studentInfoDto;
    }

    @Override
    @Transactional
    public void updateOrgStudentInfo(OrgStudentInfo orgStudentInfo, Long orgId) {
        this.customFieldValueService.saveOrUpdateCustomFieldValues((OrgUserBaseInfo)orgStudentInfo, orgStudentInfo.getStudentId(), orgId);
        StudentInfoDto studentInfoDto = this.buildStudentInfoDto(orgStudentInfo);
        List tagList = orgStudentInfo.getTagsResp();
        List<CommentInfoDto> commentDtos = orgStudentInfo.getCommentsResp();
        this.orgStudentService.modStudent(studentInfoDto, commentDtos, tagList, orgId);
    }
}

