/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.student.syn.service.impl;

import com.baijia.tianxiao.biz.student.syn.service.SyncDataService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseConsumeRuleDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.StudentStatusStatisticsByDay;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.sync.dao.TxStudentStatusDao;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.CourseApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoSignupCourseStat;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="syncStudentStatusService")
public class SyncStudentStatusServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncStudentStatusServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TxStudentStatusDao txStudentStatusDao;
    @Resource
    private TxStudentCommentDao commentDao;
    @Resource
    private OrgSignupCourseDao signupCourseDao;
    @Resource
    private OrgSignupCourseLessonDao signupCourseLessonDao;
    @Resource
    private OrgSignupRefundDao refundDao;
    @Resource
    private OrgStudentLessonDao studentLessonDao;
    @Resource
    private OrgLessonSignDao signDao;
    @Autowired
    private OrgCourseConsumeRuleDao ruleDao;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private CourseApiService courseApiService;
    @Autowired
    private OrgSignupCourseLessonService signupCourseLessonService;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    private AtomicBoolean flag = new AtomicBoolean(false);

    @Override
    public void sync(List<Integer> orgNumbers) {
        try {
            if (!this.flag.get()) {
                this.flag.set(true);
                this.syncStudentStatusByDay(orgNumbers);
                this.flag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", (Throwable)e);
        }
        finally {
            this.flag.set(false);
        }
    }

    private void syncStudentStatusByDay(List<Integer> orgNumbers) {
        List orgAccont = this.orgAccountDao.getAccountByNumbers(orgNumbers, new String[0]);
        ArrayList orgIds = Lists.newArrayList();
        for (OrgAccount o : orgAccont) {
            orgIds.add(o.getId());
        }
        ArrayList list = Lists.newArrayList();
        Map studying = this.orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.STUDYING.getStatus(), (List)orgIds);
        Map past = this.orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.PAST.getStatus(), (List)orgIds);
        Map toCharge = this.orgStudentDao.getStatisticsDayByLessonStatus(StudentLessonStatus.TO_CHARGE.getStatus(), (List)orgIds);
        for (Integer i : orgIds) {
            int studyingCount = studying.get(i) != null ? (Integer)studying.get(i) : 0;
            int pastCount = past.get(i) != null ? (Integer)past.get(i) : 0;
            int toChargeCount = toCharge.get(i) != null ? (Integer)toCharge.get(i) : 0;
            StudentStatusStatisticsByDay s = new StudentStatusStatisticsByDay();
            s.setOrgId(i);
            s.setCreateTime(DateUtil.getDiffDateTime((Date)new Date(), (int)-1));
            s.setStudyingCount(Integer.valueOf(studyingCount));
            s.setPastCount(Integer.valueOf(pastCount));
            s.setTochargeCount(Integer.valueOf(toChargeCount));
            s.setAllCount(Integer.valueOf(studyingCount + pastCount + toChargeCount));
            list.add(s);
        }
        this.txStudentStatusDao.saveAll((List)list, new String[0]);
    }

    @Override
    @Transactional(rollbackFor={Exception.class, BussinessException.class})
    public int sync(Long orgId, PageDto page) {
        List list = this.orgStudentDao.getStudentsByPage(orgId, page, new String[]{"id", "userId", "orgId", "lastRemindTime"});
        log.info("Start================");
        for (OrgStudent student : list) {
            TxStudentComment comment = this.commentDao.getRecentComment(student.getOrgId(), student.getUserId(), Integer.valueOf(StudentType.ORG_STUDENTS.getCode()));
            if (comment == null) continue;
            student.setLastRemindTime(comment.getUpdateTime());
            this.orgStudentDao.update((Object)student, new String[]{"lastRemindTime", "updateTime"});
        }
        log.info("Execute end================ success,size={}", (Object)list.size());
        return list.size();
    }

    @Override
    public List<OrgStudentLesson> reviseDeleteOrder(Long orgId, Long userId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDel", 1);
        map.put("status", SignupCourseStatus.PAY_SUCCESS);
        map.put("orgId", orgId);
        map.put("userId", userId);
        List delOrders = this.signupCourseDao.queryByCondition(map, null, new String[0]);
        List ids = ListUtil.toKeyList((Collection)delOrders, (String)"id", OrgSignupCourse.class);
        Map courseLessonMap = this.signupCourseLessonDao.listBySignupCourseIdAndLessonId((Collection)ids, null);
        ArrayList<OrgStudentLesson> result = new ArrayList<OrgStudentLesson>();
        for (OrgSignupCourseLesson lesson : courseLessonMap.values()) {
            OrgStudentLesson studentLesson = this.studentLessonDao.getByLessonIdAndUserId(lesson.getLessonId(), lesson.getUserId());
            result.add(studentLesson);
        }
        return result;
    }

    @Override
    public int syncDeleteOrder(PageDto page) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isDel", 1);
        map.put("status", SignupCourseStatus.PAY_SUCCESS);
        List delOrders = this.signupCourseDao.queryByCondition(map, page, new String[0]);
        List ids = ListUtil.toKeyList((Collection)delOrders, (String)"id", OrgSignupCourse.class);
        Map courseLessonMap = this.signupCourseLessonDao.listBySignupCourseIdAndLessonId((Collection)ids, null);
        HashMap<Long, Integer> orgMap = new HashMap<Long, Integer>();
        HashMap<String, Integer> studentCourseCountMap = new HashMap<String, Integer>();
        for (OrgSignupCourseLesson lesson : courseLessonMap.values()) {
            Integer count = (Integer)orgMap.get(lesson.getOrgId());
            if (count == null) {
                orgMap.put(lesson.getOrgId(), 1);
            } else {
                orgMap.put(lesson.getOrgId(), count + 1);
            }
            String key = lesson.getOrgId() + "_" + lesson.getUserId() + "_" + lesson.getClassId();
            Integer lessonCount = (Integer)studentCourseCountMap.get(key);
            if (lessonCount == null) {
                studentCourseCountMap.put(key, 1);
                continue;
            }
            studentCourseCountMap.put(key, lessonCount + 1);
        }
        Set keys = studentCourseCountMap.keySet();
        HashMap<Long, ArrayList<OrgStudentStat>> retMap = new HashMap<Long, ArrayList<OrgStudentStat>>();
        for (String key : keys) {
            ArrayList<OrgStudentStat> list;
            String[] arrs = key.split("_");
            long orgId = Long.parseLong(arrs[0]);
            long userId = Long.parseLong(arrs[1]);
            long classId = Long.parseLong(arrs[2]);
            List courseList = this.signupCourseDao.searchByUserIdsAndClassId(Arrays.asList(userId), Long.valueOf(classId), Long.valueOf(orgId), (Collection)SignupCourseStatus.PAY_SUCCESS);
            int leftNum = 0;
            if (courseList != null) {
                Map statMap = this.kexiaoApiService.queryKexiaoStatBySignUpCourseIds((Collection)courseList);
                for (Long id : statMap.keySet()) {
                    KexiaoSignupCourseStat stat = (KexiaoSignupCourseStat)statMap.get(id);
                    leftNum = (int)((long)leftNum + stat.getLeftUnArrangedNumber());
                }
            }
            if ((list = (ArrayList<OrgStudentStat>)retMap.get(orgId)) == null) {
                list = new ArrayList<OrgStudentStat>();
                retMap.put(orgId, list);
            }
            list.add(new OrgStudentStat(orgId, userId, classId, (Integer)studentCourseCountMap.get(key), leftNum));
        }
        log.info("[SyncData] Execute end================ success,orgMap={}", orgMap);
        log.info("[SyncData] Execute end================ success,retMap={}", retMap);
        return 0;
    }

    @Override
    public void syncMultiClass() {
        List strings = this.orgStudentCourseDao.listMultiClass();
        HashMap<Long, Integer> orgMap = new HashMap<Long, Integer>();
        HashSet<String> result = new HashSet<String>();
        for (String str : strings) {
            String[] arr = str.split("_");
            long orgId = Long.parseLong(arr[0]);
            long userId = Long.parseLong(arr[1]);
            long courseId = Long.parseLong(arr[2]);
            int count = Integer.parseInt(arr[3]);
            Integer number = (Integer)orgMap.get(orgId);
            if (number == null) {
                number = 0;
            }
            orgMap.put(orgId, number + 1);
            List courses = this.signupCourseDao.getByCourseIdAndStudentId(Long.valueOf(orgId), Long.valueOf(userId), Long.valueOf(courseId), (Collection)SignupCourseStatus.PAY_SUCCESS, new String[0]);
            HashSet<Long> signupClassIds = new HashSet<Long>();
            HashMap<String, OrgSignupCourse> courseMap = new HashMap<String, OrgSignupCourse>();
            for (OrgSignupCourse course : courses) {
                signupClassIds.add(course.getClassId());
                courseMap.put(course.getUserId() + "_" + course.getClassId(), course);
            }
            List refunds = this.refundDao.listOrderByUserIdsAndCourseId(Long.valueOf(orgId), Arrays.asList(userId), Long.valueOf(courseId));
            HashSet<Long> refundClassIds = new HashSet<Long>();
            for (OrgSignupRefund refund : refunds) {
                refundClassIds.add(refund.getClassId());
                OrgSignupCourse course = (OrgSignupCourse)courseMap.get(refund.getUserId() + "_" + refund.getClassId());
                if (course == null) {
                    log.info("[SyncData]no signup course.refund={}", (Object)refund);
                    result.add(refund.getOrgId() + "_" + refund.getClassId() + "_" + refund.getUserId() + "_0");
                    continue;
                }
                if (refund.getSignupPurchaseId().equals(course.getSignupPurchaseId())) continue;
                log.info("[SyncData] signup course id is not same.signupcourse={},refund={}", (Object)course, (Object)refund);
                result.add(refund.getOrgId() + "_" + refund.getClassId() + "_" + refund.getUserId() + "_1");
            }
            log.info("[SyncData] userId={},courseId={},signupClassIds={},refundClassIds={}", new Object[]{userId, courseId, signupClassIds, refundClassIds});
        }
        log.info("[SyncData] org static={}", orgMap);
        log.info("[SyncData] org result={}", result);
    }

    @Override
    public void syncCancelLesson() {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("lessonType", 3);
        param.put("delStatus", 0);
        PageDto pageDto = new PageDto();
        List lessons = this.studentLessonDao.queryByCondition(param, pageDto, new String[0]);
        HashMap orgStudentMap = new HashMap();
        HashMap<Long, Integer> lessonCountMap = new HashMap<Long, Integer>();
        HashMap<Long, OrgCourseConsumeRule> ruleMap = new HashMap<Long, OrgCourseConsumeRule>();
        while (lessons.size() > 0) {
            for (OrgStudentLesson lesson : lessons) {
                Integer n;
                Integer n2;
                OrgLessonSign sign = this.signDao.getStudentLessonSign(lesson.getOrgId(), lesson.getCourseId(), lesson.getLessonId(), lesson.getUserId(), Integer.valueOf(UserRole.STUDENT.getRole()));
                HashSet<Long> studentIds = (HashSet<Long>)orgStudentMap.get(sign.getOrgId());
                Integer count = (Integer)lessonCountMap.get(lesson.getOrgId());
                if (studentIds == null) {
                    studentIds = new HashSet<Long>();
                }
                if (count == null) {
                    count = 0;
                    lessonCountMap.put(lesson.getOrgId(), count);
                }
                if (sign == null) {
                    studentIds.add(lesson.getUserId());
                    Integer n3 = count;
                    Integer n4 = count = Integer.valueOf(count + 1);
                    lessonCountMap.put(lesson.getOrgId(), count);
                    log.info("[SyncData] lesson status error,no sign.studentLessonId={}", (Object)lesson.getId());
                    continue;
                }
                long realCourseId = this.courseApiService.getCourseIdByClassId(sign.getCourseId().longValue());
                OrgCourseConsumeRule rule = (OrgCourseConsumeRule)ruleMap.get(realCourseId);
                if (rule == null) {
                    n2 = count;
                    n = count = Integer.valueOf(count + 1);
                    rule = this.ruleDao.getRuleByCourseId(lesson.getOrgId(), Long.valueOf(realCourseId));
                    ruleMap.put(realCourseId, rule);
                }
                if (rule != null) {
                    LessonStatus lessonStatus = this.kexiaoApiService.getKexiaoStatus(sign, rule.getRuleValue().intValue());
                    if (lessonStatus == LessonStatus.FINISHED) {
                        studentIds.add(lesson.getUserId());
                        n = count;
                        Integer n5 = count = Integer.valueOf(count + 1);
                        log.info("[SyncData] lesson status error.studentLessonId={}", (Object)lesson.getId());
                    }
                } else {
                    studentIds.add(lesson.getUserId());
                    n2 = count;
                    n = count = Integer.valueOf(count + 1);
                    log.info("[SyncData] lesson status error,no rule.studentLessonId={}", (Object)lesson.getId());
                }
                lessonCountMap.put(lesson.getOrgId(), count);
            }
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            lessons = this.studentLessonDao.queryByCondition(param, pageDto, new String[0]);
        }
        log.info("[SyncData] orgStudent={},lessonCount={}", orgStudentMap, lessonCountMap);
    }

    @Override
    public List<OrgStudentLesson> reviseMixArrange(Long org) {
        List stringList = this.studentLessonDao.getMixArrangeLessonByOrgId(org);
        ArrayList<OrgStudentLesson> allLessons = new ArrayList<OrgStudentLesson>();
        for (String str : stringList) {
            String[] arr = str.split("_");
            long orgId = Long.parseLong(arr[0]);
            long userId = Long.parseLong(arr[1]);
            long courseId = Long.parseLong(arr[2]);
            List lessons = this.studentLessonDao.getByUserIdAndClassId(Long.valueOf(orgId), userId, courseId, null, new String[0]);
            allLessons.addAll(lessons);
        }
        return allLessons;
    }

    @Override
    public void syncMixArrange() {
        List stringList = this.studentLessonDao.getMixArrangeLesson();
        HashMap<Long, Integer> lessonCountMap = new HashMap<Long, Integer>();
        ArrayList<Object> statList = new ArrayList<Object>();
        for (String str : stringList) {
            Object stat;
            String[] arr = str.split("_");
            long orgId = Long.parseLong(arr[0]);
            long userId = Long.parseLong(arr[1]);
            long courseId = Long.parseLong(arr[2]);
            int unknowCount = Integer.parseInt(arr[3]);
            Integer number = (Integer)lessonCountMap.get(orgId);
            if (number == null) {
                number = 0;
            }
            lessonCountMap.put(orgId, number + 1);
            List courseList = this.signupCourseDao.searchByUserIdsAndClassId(Arrays.asList(userId), Long.valueOf(courseId), Long.valueOf(orgId), (Collection)SignupCourseStatus.PAY_SUCCESS);
            if (courseList == null) continue;
            boolean isComplete = true;
            for (OrgSignupCourse course : courseList) {
                if (course.getLessonCount() >= 1) continue;
                stat = new OrgStudentStat(orgId, userId, course.getClassId(), 0, 0);
                ((OrgStudentStat)stat).setChargeUnit(course.getChargeUnit());
                ((OrgStudentStat)stat).setCompleteStatus(1);
                isComplete = false;
                statList.add(stat);
                log.info("[SyncData] stat={}", stat);
            }
            if (!isComplete) continue;
            int leftNum = 0;
            Map statMap = this.kexiaoApiService.queryKexiaoStatBySignUpCourseIds((Collection)courseList);
            for (Long id : statMap.keySet()) {
                KexiaoSignupCourseStat stat2 = (KexiaoSignupCourseStat)statMap.get(id);
                leftNum = (int)((long)leftNum + stat2.getLeftUnArrangedNumber());
            }
            stat = new OrgStudentStat(orgId, userId, courseId, unknowCount, leftNum);
            statList.add(stat);
            log.info("[SyncData] stat={}", stat);
        }
        log.info("[SyncData]lessonCount={}", lessonCountMap);
        log.info("[SyncData] OrgStudentStatList1111={}", statList);
    }

    class OrgStudentStat {
        private long orgId;
        private long userId;
        private long classId;
        private int delOrgLessonCount;
        private int freeCount;
        private int leftCount;
        private int chargeUnit;
        private int completeStatus;

        public OrgStudentStat(long orgId, long userId, long classId, int delOrgLessonCount, int leftCount) {
            this.orgId = orgId;
            this.userId = userId;
            this.classId = classId;
            this.delOrgLessonCount = delOrgLessonCount;
            this.leftCount = leftCount;
        }

        public String toString() {
            return String.format("%10d%10d%10d%10d%10d%10d%10d%10d", this.orgId, this.userId, this.classId, this.delOrgLessonCount, this.leftCount, this.delOrgLessonCount - this.leftCount, this.chargeUnit, this.completeStatus);
        }

        public long getOrgId() {
            return this.orgId;
        }

        public long getUserId() {
            return this.userId;
        }

        public long getClassId() {
            return this.classId;
        }

        public int getDelOrgLessonCount() {
            return this.delOrgLessonCount;
        }

        public int getFreeCount() {
            return this.freeCount;
        }

        public int getLeftCount() {
            return this.leftCount;
        }

        public int getChargeUnit() {
            return this.chargeUnit;
        }

        public int getCompleteStatus() {
            return this.completeStatus;
        }

        public void setOrgId(long orgId) {
            this.orgId = orgId;
        }

        public void setUserId(long userId) {
            this.userId = userId;
        }

        public void setClassId(long classId) {
            this.classId = classId;
        }

        public void setDelOrgLessonCount(int delOrgLessonCount) {
            this.delOrgLessonCount = delOrgLessonCount;
        }

        public void setFreeCount(int freeCount) {
            this.freeCount = freeCount;
        }

        public void setLeftCount(int leftCount) {
            this.leftCount = leftCount;
        }

        public void setChargeUnit(int chargeUnit) {
            this.chargeUnit = chargeUnit;
        }

        public void setCompleteStatus(int completeStatus) {
            this.completeStatus = completeStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrgStudentStat)) {
                return false;
            }
            OrgStudentStat other = (OrgStudentStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOrgId() != other.getOrgId()) {
                return false;
            }
            if (this.getUserId() != other.getUserId()) {
                return false;
            }
            if (this.getClassId() != other.getClassId()) {
                return false;
            }
            if (this.getDelOrgLessonCount() != other.getDelOrgLessonCount()) {
                return false;
            }
            if (this.getFreeCount() != other.getFreeCount()) {
                return false;
            }
            if (this.getLeftCount() != other.getLeftCount()) {
                return false;
            }
            if (this.getChargeUnit() != other.getChargeUnit()) {
                return false;
            }
            return this.getCompleteStatus() == other.getCompleteStatus();
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrgStudentStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $orgId = this.getOrgId();
            result = result * 59 + (int)($orgId >>> 32 ^ $orgId);
            long $userId = this.getUserId();
            result = result * 59 + (int)($userId >>> 32 ^ $userId);
            long $classId = this.getClassId();
            result = result * 59 + (int)($classId >>> 32 ^ $classId);
            result = result * 59 + this.getDelOrgLessonCount();
            result = result * 59 + this.getFreeCount();
            result = result * 59 + this.getLeftCount();
            result = result * 59 + this.getChargeUnit();
            result = result * 59 + this.getCompleteStatus();
            return result;
        }
    }
}

